/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.predicate.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.LinkedHashMap;
import java.util.Map;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonObjectAccessor;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchCompatibilityChecker;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchScopedIndexFieldComponent;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchScopeModel;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSucceedingCompatibilityChecker;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.AbstractElasticsearchSearchPredicateBuilder;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicateBuilder;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicateBuilderFactoryImpl;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicateContext;
import org.hibernate.search.backend.elasticsearch.types.predicate.impl.ElasticsearchFieldPredicateBuilderFactory;
import org.hibernate.search.backend.elasticsearch.types.predicate.impl.ElasticsearchSimpleQueryStringPredicateBuilderFieldContext;
import org.hibernate.search.engine.search.predicate.spi.SimpleQueryStringPredicateBuilder;

public class ElasticsearchSimpleQueryStringPredicateBuilder
extends AbstractElasticsearchSearchPredicateBuilder
implements SimpleQueryStringPredicateBuilder<ElasticsearchSearchPredicateBuilder> {
    private static final JsonObjectAccessor SIMPLE_QUERY_STRING_ACCESSOR = JsonAccessor.root().property("simple_query_string").asObject();
    private static final JsonAccessor<String> QUERY_ACCESSOR = JsonAccessor.root().property("query").asString();
    private static final JsonAccessor<JsonElement> DEFAULT_OPERATOR_ACCESSOR = JsonAccessor.root().property("default_operator");
    private static final JsonAccessor<JsonArray> FIELDS_ACCESSOR = JsonAccessor.root().property("fields").asArray();
    private static final JsonAccessor<String> ANALYZER_ACCESSOR = JsonAccessor.root().property("analyzer").asString();
    private static final JsonPrimitive AND_OPERATOR_KEYWORD_JSON = new JsonPrimitive("and");
    private static final JsonPrimitive OR_OPERATOR_KEYWORD_JSON = new JsonPrimitive("or");
    private final ElasticsearchSearchScopeModel scopeModel;
    private final Map<String, ElasticsearchSimpleQueryStringPredicateBuilderFieldContext> fields = new LinkedHashMap<String, ElasticsearchSimpleQueryStringPredicateBuilderFieldContext>();
    private JsonPrimitive defaultOperator = OR_OPERATOR_KEYWORD_JSON;
    private String simpleQueryString;
    private String analyzer;
    private ElasticsearchCompatibilityChecker analyzerChecker = new ElasticsearchSucceedingCompatibilityChecker();

    ElasticsearchSimpleQueryStringPredicateBuilder(ElasticsearchSearchScopeModel scopeModel) {
        this.scopeModel = scopeModel;
    }

    public void withAndAsDefaultOperator() {
        this.defaultOperator = AND_OPERATOR_KEYWORD_JSON;
    }

    public SimpleQueryStringPredicateBuilder.FieldContext field(String absoluteFieldPath) {
        ElasticsearchSimpleQueryStringPredicateBuilderFieldContext field = this.fields.get(absoluteFieldPath);
        if (field == null) {
            ElasticsearchScopedIndexFieldComponent<ElasticsearchFieldPredicateBuilderFactory> fieldComponent = this.scopeModel.getSchemaNodeComponent(absoluteFieldPath, ElasticsearchSearchPredicateBuilderFactoryImpl.PREDICATE_BUILDER_FACTORY_RETRIEVAL_STRATEGY);
            field = fieldComponent.getComponent().createSimpleQueryStringFieldContext(absoluteFieldPath);
            this.analyzerChecker = this.analyzerChecker.combine(fieldComponent.getAnalyzerCompatibilityChecker());
            this.fields.put(absoluteFieldPath, field);
        }
        return field;
    }

    public void simpleQueryString(String simpleQueryString) {
        this.simpleQueryString = simpleQueryString;
    }

    public void analyzer(String analyzerName) {
        this.analyzer = analyzerName;
    }

    public void skipAnalysis() {
        this.analyzer("keyword");
    }

    @Override
    protected JsonObject doBuild(ElasticsearchSearchPredicateContext context, JsonObject outerObject, JsonObject innerObject) {
        if (this.analyzer == null) {
            this.analyzerChecker.failIfNotCompatible();
        }
        QUERY_ACCESSOR.set(innerObject, this.simpleQueryString);
        DEFAULT_OPERATOR_ACCESSOR.set(innerObject, (JsonElement)this.defaultOperator);
        JsonArray fieldArray = new JsonArray();
        for (ElasticsearchSimpleQueryStringPredicateBuilderFieldContext fieldContext : this.fields.values()) {
            fieldArray.add((JsonElement)fieldContext.build());
        }
        FIELDS_ACCESSOR.set(innerObject, fieldArray);
        if (this.analyzer != null) {
            ANALYZER_ACCESSOR.set(innerObject, this.analyzer);
        }
        SIMPLE_QUERY_STRING_ACCESSOR.set(outerObject, innerObject);
        return outerObject;
    }
}

