/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.projection.impl;

import com.google.gson.JsonObject;
import java.lang.invoke.MethodHandles;
import java.util.function.Function;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.multitenancy.impl.MultiTenancyStrategy;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchDocumentReference;
import org.hibernate.search.engine.search.DocumentReference;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class DocumentReferenceExtractorHelper {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final JsonAccessor<String> HIT_INDEX_NAME_ACCESSOR = JsonAccessor.root().property("_index").asString();
    private final Function<String, String> indexNameConverter;
    private final MultiTenancyStrategy multiTenancyStrategy;

    public DocumentReferenceExtractorHelper(Function<String, String> indexNameConverter, MultiTenancyStrategy multiTenancyStrategy) {
        this.indexNameConverter = indexNameConverter;
        this.multiTenancyStrategy = multiTenancyStrategy;
    }

    public void contributeRequest(JsonObject requestBody) {
        this.multiTenancyStrategy.contributeToSearchRequest(requestBody);
    }

    public DocumentReference extractDocumentReference(JsonObject hit) {
        String indexName = HIT_INDEX_NAME_ACCESSOR.get(hit).map(this.indexNameConverter).orElseThrow(log::elasticsearchResponseMissingData);
        String id = this.multiTenancyStrategy.extractTenantScopedDocumentId(hit);
        return new ElasticsearchDocumentReference(indexName, id);
    }
}

