/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.projection.impl;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Optional;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonArrayAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonObjectAccessor;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchSearchProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.SearchProjectionExtractContext;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.SearchProjectionTransformContext;
import org.hibernate.search.engine.search.query.spi.LoadingResult;
import org.hibernate.search.engine.search.query.spi.ProjectionHitMapper;

class ElasticsearchSourceProjection
implements ElasticsearchSearchProjection<String, String> {
    private static final JsonArrayAccessor REQUEST_SOURCE_ACCESSOR = JsonAccessor.root().property("_source").asArray();
    private static final JsonObjectAccessor HIT_SOURCE_ACCESSOR = JsonAccessor.root().property("_source").asObject();
    private static final JsonPrimitive WILDCARD_ALL = new JsonPrimitive("*");
    private final Gson gson;

    ElasticsearchSourceProjection(Gson gson) {
        this.gson = gson;
    }

    @Override
    public void contributeRequest(JsonObject requestBody, SearchProjectionExtractContext context) {
        JsonArray source = REQUEST_SOURCE_ACCESSOR.getOrCreate(requestBody, JsonArray::new);
        if (!source.contains((JsonElement)WILDCARD_ALL)) {
            source.add((JsonElement)WILDCARD_ALL);
        }
    }

    @Override
    public String extract(ProjectionHitMapper<?, ?> projectionHitMapper, JsonObject responseBody, JsonObject hit, SearchProjectionExtractContext context) {
        Optional sourceElement = HIT_SOURCE_ACCESSOR.get(hit);
        if (sourceElement.isPresent()) {
            return this.gson.toJson((JsonElement)sourceElement.get());
        }
        return null;
    }

    @Override
    public String transform(LoadingResult<?> loadingResult, String extractedData, SearchProjectionTransformContext context) {
        return extractedData;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

