/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.projection.impl;

import com.google.gson.Gson;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.DocumentReferenceExtractorHelper;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchDocumentReferenceProjectionBuilder;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchExplanationProjectionBuilder;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchObjectProjectionBuilder;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchReferenceProjectionBuilder;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchScoreProjectionBuilder;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchSourceProjectionBuilder;
import org.hibernate.search.engine.search.projection.spi.SearchProjectionBuilder;

public class SearchProjectionBackendContext {
    private final ElasticsearchDocumentReferenceProjectionBuilder documentReferenceProjectionBuilder;
    private final ElasticsearchObjectProjectionBuilder objectProjectionBuilder;
    private final ElasticsearchReferenceProjectionBuilder referenceProjectionBuilder;
    private final ElasticsearchScoreProjectionBuilder scoreProjectionBuilder;
    private final ElasticsearchSourceProjectionBuilder sourceProjectionBuilder;
    private final ElasticsearchExplanationProjectionBuilder explanationProjectionBuilder;

    public SearchProjectionBackendContext(DocumentReferenceExtractorHelper documentReferenceExtractorHelper, Gson userFacingGson) {
        this.documentReferenceProjectionBuilder = new ElasticsearchDocumentReferenceProjectionBuilder(documentReferenceExtractorHelper);
        this.objectProjectionBuilder = new ElasticsearchObjectProjectionBuilder(documentReferenceExtractorHelper);
        this.referenceProjectionBuilder = new ElasticsearchReferenceProjectionBuilder(documentReferenceExtractorHelper);
        this.scoreProjectionBuilder = new ElasticsearchScoreProjectionBuilder();
        this.sourceProjectionBuilder = new ElasticsearchSourceProjectionBuilder(userFacingGson);
        this.explanationProjectionBuilder = new ElasticsearchExplanationProjectionBuilder(userFacingGson);
    }

    ElasticsearchDocumentReferenceProjectionBuilder getDocumentReferenceProjectionBuilder() {
        return this.documentReferenceProjectionBuilder;
    }

    <O> ElasticsearchObjectProjectionBuilder<O> getObjectProjectionBuilder() {
        return this.objectProjectionBuilder;
    }

    <R> ElasticsearchReferenceProjectionBuilder<R> getReferenceProjectionBuilder() {
        return this.referenceProjectionBuilder;
    }

    ElasticsearchScoreProjectionBuilder getScoreProjectionBuilder() {
        return this.scoreProjectionBuilder;
    }

    ElasticsearchSourceProjectionBuilder getSourceProjectionBuilder() {
        return this.sourceProjectionBuilder;
    }

    public SearchProjectionBuilder<String> getExplanationProjectionBuilder() {
        return this.explanationProjectionBuilder;
    }
}

