/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.projection.impl;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.hibernate.search.engine.spatial.GeoPoint;

public class SearchProjectionExtractContext {
    private final Map<DistanceSortKey, Integer> distanceSorts;

    public SearchProjectionExtractContext(Map<DistanceSortKey, Integer> distanceSorts) {
        this.distanceSorts = distanceSorts != null ? Collections.unmodifiableMap(distanceSorts) : null;
    }

    Integer getDistanceSortIndex(String absoluteFieldPath, GeoPoint location) {
        if (this.distanceSorts == null) {
            return null;
        }
        return this.distanceSorts.get(new DistanceSortKey(absoluteFieldPath, location));
    }

    public static class DistanceSortKey {
        private final String absoluteFieldPath;
        private final GeoPoint location;

        public DistanceSortKey(String absoluteFieldPath, GeoPoint location) {
            this.absoluteFieldPath = absoluteFieldPath;
            this.location = location;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof DistanceSortKey)) {
                return false;
            }
            DistanceSortKey other = (DistanceSortKey)obj;
            return Objects.equals(this.absoluteFieldPath, other.absoluteFieldPath) && Objects.equals(this.location, other.location);
        }

        public int hashCode() {
            return Objects.hash(this.absoluteFieldPath, this.location);
        }
    }
}

