/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.query.impl;

import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchContext;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchQueryElementCollector;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchScopeModel;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicateBuilderFactoryImpl;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchSearchProjectionBuilderFactory;
import org.hibernate.search.backend.elasticsearch.search.query.impl.ElasticsearchSearchQueryBuilderFactory;
import org.hibernate.search.backend.elasticsearch.search.query.impl.SearchBackendContext;
import org.hibernate.search.backend.elasticsearch.search.sort.impl.ElasticsearchSearchSortBuilderFactoryImpl;
import org.hibernate.search.engine.mapper.mapping.context.spi.MappingContextImplementor;
import org.hibernate.search.engine.search.dsl.spi.IndexSearchScope;

public class ElasticsearchIndexSearchScope
implements IndexSearchScope<ElasticsearchSearchQueryElementCollector> {
    private final ElasticsearchSearchScopeModel model;
    private final ElasticsearchSearchPredicateBuilderFactoryImpl searchPredicateFactory;
    private final ElasticsearchSearchSortBuilderFactoryImpl searchSortFactory;
    private final ElasticsearchSearchQueryBuilderFactory searchQueryFactory;
    private final ElasticsearchSearchProjectionBuilderFactory searchProjectionFactory;

    public ElasticsearchIndexSearchScope(MappingContextImplementor mappingContext, SearchBackendContext searchBackendContext, ElasticsearchSearchScopeModel model) {
        ElasticsearchSearchContext searchContext = searchBackendContext.createSearchContext(mappingContext);
        this.model = model;
        this.searchPredicateFactory = new ElasticsearchSearchPredicateBuilderFactoryImpl(searchContext, model);
        this.searchSortFactory = new ElasticsearchSearchSortBuilderFactoryImpl(searchContext, model);
        this.searchProjectionFactory = new ElasticsearchSearchProjectionBuilderFactory(searchBackendContext.getSearchProjectionBackendContext(), model);
        this.searchQueryFactory = new ElasticsearchSearchQueryBuilderFactory(searchBackendContext, model, this.searchProjectionFactory);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "indexNames=" + this.model.getHibernateSearchIndexNames() + "]";
    }

    public ElasticsearchSearchPredicateBuilderFactoryImpl getSearchPredicateBuilderFactory() {
        return this.searchPredicateFactory;
    }

    public ElasticsearchSearchSortBuilderFactoryImpl getSearchSortBuilderFactory() {
        return this.searchSortFactory;
    }

    public ElasticsearchSearchQueryBuilderFactory getSearchQueryBuilderFactory() {
        return this.searchQueryFactory;
    }

    public ElasticsearchSearchProjectionBuilderFactory getSearchProjectionFactory() {
        return this.searchProjectionFactory;
    }
}

