/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.query.impl;

import java.util.Collections;
import java.util.List;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchSearchProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.SearchProjectionTransformContext;
import org.hibernate.search.engine.mapper.session.context.spi.SessionContextImplementor;
import org.hibernate.search.engine.search.query.spi.IndexSearchResult;
import org.hibernate.search.engine.search.query.spi.LoadingResult;
import org.hibernate.search.engine.search.query.spi.ProjectionHitMapper;
import org.hibernate.search.engine.search.query.spi.SimpleIndexSearchResult;

public class ElasticsearchLoadableSearchResult<T> {
    private final ProjectionHitMapper<?, ?> projectionHitMapper;
    private final ElasticsearchSearchProjection<?, T> rootProjection;
    private final long hitCount;
    private List<Object> extractedData;

    ElasticsearchLoadableSearchResult(ProjectionHitMapper<?, ?> projectionHitMapper, ElasticsearchSearchProjection<?, T> rootProjection, long hitCount, List<Object> extractedData) {
        this.projectionHitMapper = projectionHitMapper;
        this.rootProjection = rootProjection;
        this.hitCount = hitCount;
        this.extractedData = extractedData;
    }

    IndexSearchResult<T> loadBlocking(SessionContextImplementor sessionContext) {
        SearchProjectionTransformContext transformContext = new SearchProjectionTransformContext(sessionContext);
        LoadingResult loadingResult = this.projectionHitMapper.loadBlocking();
        for (int i = 0; i < this.extractedData.size(); ++i) {
            T transformed = ElasticsearchSearchProjection.transformUnsafe(this.rootProjection, loadingResult, this.extractedData.get(i), transformContext);
            this.extractedData.set(i, transformed);
        }
        List<Object> loadedHits = Collections.unmodifiableList(this.extractedData);
        this.extractedData = null;
        return new SimpleIndexSearchResult(this.hitCount, loadedHits);
    }
}

