/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.query.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchQueryElementCollector;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchScopeModel;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchCompositeListProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchObjectProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchReferenceProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchSearchProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchSearchProjectionBuilderFactory;
import org.hibernate.search.backend.elasticsearch.search.query.impl.ElasticsearchSearchQueryBuilder;
import org.hibernate.search.backend.elasticsearch.search.query.impl.SearchBackendContext;
import org.hibernate.search.engine.mapper.session.context.spi.SessionContextImplementor;
import org.hibernate.search.engine.search.SearchProjection;
import org.hibernate.search.engine.search.query.spi.ProjectionHitMapper;
import org.hibernate.search.engine.search.query.spi.SearchQueryBuilder;
import org.hibernate.search.engine.search.query.spi.SearchQueryBuilderFactory;

class ElasticsearchSearchQueryBuilderFactory
implements SearchQueryBuilderFactory<ElasticsearchSearchQueryElementCollector> {
    private final SearchBackendContext searchBackendContext;
    private final ElasticsearchSearchScopeModel scopeModel;
    private final ElasticsearchSearchProjectionBuilderFactory searchProjectionFactory;

    ElasticsearchSearchQueryBuilderFactory(SearchBackendContext searchBackendContext, ElasticsearchSearchScopeModel scopeModel, ElasticsearchSearchProjectionBuilderFactory searchProjectionFactory) {
        this.searchBackendContext = searchBackendContext;
        this.scopeModel = scopeModel;
        this.searchProjectionFactory = searchProjectionFactory;
    }

    public <O> SearchQueryBuilder<O, ElasticsearchSearchQueryElementCollector> asObject(SessionContextImplementor sessionContext, ProjectionHitMapper<?, O> projectionHitMapper) {
        return this.createSearchQueryBuilder(sessionContext, projectionHitMapper, new ElasticsearchObjectProjection(this.searchBackendContext.getDocumentReferenceExtractorHelper()));
    }

    public <T> SearchQueryBuilder<T, ElasticsearchSearchQueryElementCollector> asReference(SessionContextImplementor sessionContext, ProjectionHitMapper<?, ?> projectionHitMapper) {
        return this.createSearchQueryBuilder(sessionContext, projectionHitMapper, new ElasticsearchReferenceProjection(this.searchBackendContext.getDocumentReferenceExtractorHelper()));
    }

    public <T> SearchQueryBuilder<T, ElasticsearchSearchQueryElementCollector> asProjection(SessionContextImplementor sessionContext, ProjectionHitMapper<?, ?> projectionHitMapper, SearchProjection<T> projection) {
        return this.createSearchQueryBuilder(sessionContext, projectionHitMapper, this.searchProjectionFactory.toImplementation(projection));
    }

    public SearchQueryBuilder<List<?>, ElasticsearchSearchQueryElementCollector> asProjections(SessionContextImplementor sessionContext, ProjectionHitMapper<?, ?> projectionHitMapper, SearchProjection<?> ... projections) {
        return this.createSearchQueryBuilder(sessionContext, projectionHitMapper, this.createRootProjection(projections));
    }

    private ElasticsearchSearchProjection<?, List<?>> createRootProjection(SearchProjection<?>[] projections) {
        ArrayList children = new ArrayList(projections.length);
        for (SearchProjection<?> projection : projections) {
            children.add(this.searchProjectionFactory.toImplementation(projection));
        }
        return new ElasticsearchCompositeListProjection(Function.identity(), children);
    }

    private <T> ElasticsearchSearchQueryBuilder<T> createSearchQueryBuilder(SessionContextImplementor sessionContext, ProjectionHitMapper<?, ?> projectionHitMapper, ElasticsearchSearchProjection<?, T> rootProjection) {
        return this.searchBackendContext.createSearchQueryBuilder(this.scopeModel.getElasticsearchIndexNames(), sessionContext, projectionHitMapper, rootProjection);
    }
}

