/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.codec.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonPrimitive;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonElementTypes;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchFieldCodec;

public class ElasticsearchBooleanFieldCodec
implements ElasticsearchFieldCodec<Boolean> {
    public static final ElasticsearchBooleanFieldCodec INSTANCE = new ElasticsearchBooleanFieldCodec();

    private ElasticsearchBooleanFieldCodec() {
    }

    @Override
    public JsonElement encode(Boolean value) {
        if (value == null) {
            return JsonNull.INSTANCE;
        }
        return new JsonPrimitive(value);
    }

    @Override
    public Boolean decode(JsonElement element) {
        if (element == null || element.isJsonNull()) {
            return null;
        }
        return JsonElementTypes.BOOLEAN.fromElement(element);
    }

    @Override
    public boolean isCompatibleWith(ElasticsearchFieldCodec<?> other) {
        return INSTANCE == other;
    }
}

