/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.codec.impl;

import java.time.LocalDate;
import java.time.MonthDay;
import java.time.format.DateTimeFormatter;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.AbstractElasticsearchJavaTimeFieldCodec;

public class ElasticsearchMonthDayFieldCodec
extends AbstractElasticsearchJavaTimeFieldCodec<MonthDay> {
    private static final int LEAP_YEAR = 0;

    public ElasticsearchMonthDayFieldCodec(DateTimeFormatter delegate) {
        super(delegate);
    }

    @Override
    protected String nullUnsafeFormat(MonthDay value) {
        LocalDate date = value.atYear(0);
        return this.formatter.format(date);
    }

    @Override
    protected MonthDay nullUnsafeParse(String stringValue) {
        LocalDate date = LocalDate.parse(stringValue, this.formatter);
        return MonthDay.from(date);
    }
}

