/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.format.impl;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.hibernate.search.backend.elasticsearch.types.format.impl.Elasticsearch7DefaultFieldFormatProvider;
import org.hibernate.search.backend.elasticsearch.types.format.impl.ElasticsearchDefaultFieldFormatProvider;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.impl.CollectionHelper;

public class Elasticsearch6DefaultFieldFormatProvider
implements ElasticsearchDefaultFieldFormatProvider {
    private static final Map<Class<? extends TemporalAccessor>, List<String>> ELASTICSEARCH_6_FORMAT_PATTERNS_BY_TYPE;
    private final Map<Class<? extends TemporalAccessor>, DateTimeFormatter> dateTimeFormatters = new HashMap<Class<? extends TemporalAccessor>, DateTimeFormatter>();

    public Elasticsearch6DefaultFieldFormatProvider() {
        for (Map.Entry<Class<? extends TemporalAccessor>, String> entry : Elasticsearch7DefaultFieldFormatProvider.JAVA_TIME_FORMAT_PATTERN_BY_TYPE.entrySet()) {
            Class<? extends TemporalAccessor> type = entry.getKey();
            String pattern = entry.getValue();
            this.dateTimeFormatters.put(type, DateTimeFormatter.ofPattern(pattern, Locale.ROOT));
        }
    }

    @Override
    public DateTimeFormatter getDefaultDateTimeFormatter(Class<? extends TemporalAccessor> fieldType) {
        DateTimeFormatter result = this.dateTimeFormatters.get(fieldType);
        if (result == null) {
            throw new AssertionFailure("Unknown date time formatter for " + fieldType);
        }
        return result;
    }

    @Override
    public List<String> getDefaultMappingFormat(Class<? extends TemporalAccessor> fieldType) {
        List<String> result = ELASTICSEARCH_6_FORMAT_PATTERNS_BY_TYPE.get(fieldType);
        if (result == null) {
            throw new AssertionFailure("Unknown mapping format for " + fieldType);
        }
        return result;
    }

    static {
        HashMap<Class, List> map = new HashMap<Class, List>();
        map.put(Instant.class, CollectionHelper.asImmutableList((Object[])new String[]{"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", "yyyyyyyyy-MM-dd'T'HH:mm:ss.SSSSSSSSS'Z'"}));
        map.put(LocalDate.class, CollectionHelper.asImmutableList((Object[])new String[]{"yyyy-MM-dd", "yyyyyyyyy-MM-dd"}));
        map.put(LocalTime.class, CollectionHelper.asImmutableList((Object[])new String[]{"HH:mm:ss.SSS", "HH:mm:ss.SSSSSSSSS"}));
        map.put(LocalDateTime.class, CollectionHelper.asImmutableList((Object[])new String[]{"yyyy-MM-dd'T'HH:mm:ss.SSS", "yyyyyyyyy-MM-dd'T'HH:mm:ss.SSSSSSSSS"}));
        map.put(OffsetTime.class, CollectionHelper.asImmutableList((Object[])new String[]{"HH:mm:ss.SSSZZ", "HH:mm:ss.SSSSSSSSSZZ"}));
        map.put(OffsetDateTime.class, CollectionHelper.asImmutableList((Object[])new String[]{"yyyy-MM-dd'T'HH:mm:ss.SSSZZ", "yyyyyyyyy-MM-dd'T'HH:mm:ss.SSSSSSSSSZZ"}));
        map.put(ZonedDateTime.class, CollectionHelper.asImmutableList((Object[])new String[]{"yyyy-MM-dd'T'HH:mm:ss.SSSZZ'['ZZZ']'", "yyyyyyyyy-MM-dd'T'HH:mm:ss.SSSSSSSSSZZ'['ZZZ']'", "yyyyyyyyy-MM-dd'T'HH:mm:ss.SSSSSSSSSZZ'['ZZ']'"}));
        map.put(Year.class, CollectionHelper.asImmutableList((Object[])new String[]{"yyyy", "yyyyyyyyy"}));
        map.put(YearMonth.class, CollectionHelper.asImmutableList((Object[])new String[]{"yyyy-MM", "yyyyyyyyy-MM"}));
        map.put(MonthDay.class, CollectionHelper.asImmutableList((Object[])new String[]{"yyyy-MM-dd"}));
        ELASTICSEARCH_6_FORMAT_PATTERNS_BY_TYPE = Collections.unmodifiableMap(map);
    }
}

