/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.work.impl;

import com.google.gson.JsonObject;
import org.hibernate.search.backend.elasticsearch.client.impl.Paths;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchRequest;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchResponse;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.backend.elasticsearch.work.builder.impl.ExplainWorkBuilder;
import org.hibernate.search.backend.elasticsearch.work.impl.AbstractSimpleElasticsearchWork;
import org.hibernate.search.backend.elasticsearch.work.impl.DefaultElasticsearchRequestSuccessAssessor;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchWorkExecutionContext;
import org.hibernate.search.backend.elasticsearch.work.result.impl.ExplainResult;

public class ExplainWork
extends AbstractSimpleElasticsearchWork<ExplainResult> {
    protected ExplainWork(Builder builder) {
        super(builder);
    }

    @Override
    protected ExplainResult generateResult(ElasticsearchWorkExecutionContext context, ElasticsearchResponse response) {
        JsonObject body = response.getBody();
        return new ExplainResultImpl(body);
    }

    private static class ExplainResultImpl
    implements ExplainResult {
        private final JsonObject jsonObject;

        public ExplainResultImpl(JsonObject jsonObject) {
            this.jsonObject = jsonObject;
        }

        @Override
        public JsonObject getJsonObject() {
            return this.jsonObject;
        }
    }

    public static class Builder
    extends AbstractSimpleElasticsearchWork.AbstractBuilder<Builder>
    implements ExplainWorkBuilder {
        private final URLEncodedString indexName;
        private final URLEncodedString typeName;
        private final URLEncodedString id;
        private final JsonObject payload;

        public Builder(URLEncodedString indexName, URLEncodedString typeName, URLEncodedString id, JsonObject payload) {
            super(null, DefaultElasticsearchRequestSuccessAssessor.INSTANCE);
            this.indexName = indexName;
            this.typeName = typeName;
            this.id = id;
            this.payload = payload;
        }

        @Override
        protected ElasticsearchRequest buildRequest() {
            ElasticsearchRequest.Builder builder = ElasticsearchRequest.get().pathComponent(this.indexName).pathComponent(this.typeName).pathComponent(this.id).pathComponent(Paths._EXPLAIN).body(this.payload);
            return builder.build();
        }

        @Override
        public ExplainWork build() {
            return new ExplainWork(this);
        }
    }
}

