/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.work.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchRequest;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchResponse;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.backend.elasticsearch.work.builder.impl.IndexWorkBuilder;
import org.hibernate.search.backend.elasticsearch.work.impl.AbstractSimpleBulkableElasticsearchWork;
import org.hibernate.search.backend.elasticsearch.work.impl.DefaultElasticsearchRequestSuccessAssessor;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchWorkExecutionContext;

public class IndexWork
extends AbstractSimpleBulkableElasticsearchWork<Void> {
    public IndexWork(Builder builder) {
        super(builder);
    }

    @Override
    protected Void generateResult(ElasticsearchWorkExecutionContext context, ElasticsearchResponse response) {
        return null;
    }

    @Override
    protected Void generateResult(ElasticsearchWorkExecutionContext context, JsonObject bulkResponseItem) {
        return null;
    }

    public static class Builder
    extends AbstractSimpleBulkableElasticsearchWork.AbstractBuilder<Builder>
    implements IndexWorkBuilder {
        private final URLEncodedString indexName;
        private final URLEncodedString typeName;
        private final URLEncodedString id;
        private final String routingKey;
        private final JsonObject document;

        public Builder(URLEncodedString indexName, URLEncodedString typeName, URLEncodedString id, String routingKey, JsonObject document) {
            super(indexName, DefaultElasticsearchRequestSuccessAssessor.INSTANCE);
            this.indexName = indexName;
            this.typeName = typeName;
            this.id = id;
            this.routingKey = routingKey;
            this.document = document;
        }

        @Override
        protected ElasticsearchRequest buildRequest() {
            ElasticsearchRequest.Builder builder = ElasticsearchRequest.put().pathComponent(this.indexName).pathComponent(this.typeName).pathComponent(this.id).body(this.document);
            if (this.routingKey != null) {
                builder.param("routing", this.routingKey);
            }
            return builder.build();
        }

        @Override
        protected JsonObject buildBulkableActionMetadata() {
            JsonObject index = new JsonObject();
            index.addProperty("_index", this.indexName.original);
            index.addProperty("_type", this.typeName.original);
            index.addProperty("_id", this.id.original);
            JsonObject result = new JsonObject();
            result.add("index", (JsonElement)index);
            return result;
        }

        @Override
        public IndexWork build() {
            return new IndexWork(this);
        }
    }
}

