/*
 * Hibernate Search, full-text search for your domain model
 *
 * License: GNU Lesser General Public License (LGPL), version 2.1 or later
 * See the lgpl.txt file in the root directory or <http://www.gnu.org/licenses/lgpl-2.1.html>.
 */
package org.hibernate.search.backend.elasticsearch.search.dsl.projection.impl;

import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchSearchProjectionBuilderFactory;
import org.hibernate.search.engine.search.SearchProjection;
import org.hibernate.search.engine.search.dsl.projection.SearchProjectionTerminalContext;
import org.hibernate.search.engine.search.projection.spi.SearchProjectionBuilder;

public class ElasticsearchExplanationProjectionContext implements SearchProjectionTerminalContext<String> {
	private final SearchProjectionBuilder<String> builder;

	ElasticsearchExplanationProjectionContext(ElasticsearchSearchProjectionBuilderFactory factory) {
		this.builder = factory.explanation();
	}

	@Override
	public SearchProjection<String> toProjection() {
		return builder.build();
	}
}
