/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.lang.invoke.MethodHandles;
import java.util.Locale;
import java.util.Optional;
import org.hibernate.search.backend.elasticsearch.analysis.ElasticsearchAnalysisConfigurer;
import org.hibernate.search.backend.elasticsearch.analysis.model.dsl.impl.ElasticsearchAnalysisDefinitionContainerContextImpl;
import org.hibernate.search.backend.elasticsearch.analysis.model.impl.ElasticsearchAnalysisDefinitionRegistry;
import org.hibernate.search.backend.elasticsearch.cfg.ElasticsearchBackendSettings;
import org.hibernate.search.backend.elasticsearch.cfg.ElasticsearchVersion;
import org.hibernate.search.backend.elasticsearch.cfg.MultiTenancyStrategyName;
import org.hibernate.search.backend.elasticsearch.cfg.spi.ElasticsearchBackendSpiSettings;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchClientFactory;
import org.hibernate.search.backend.elasticsearch.dialect.impl.ElasticsearchDialectFactory;
import org.hibernate.search.backend.elasticsearch.dialect.model.impl.ElasticsearchModelDialect;
import org.hibernate.search.backend.elasticsearch.gson.impl.DefaultGsonProvider;
import org.hibernate.search.backend.elasticsearch.gson.spi.GsonProvider;
import org.hibernate.search.backend.elasticsearch.impl.ElasticsearchBackendImpl;
import org.hibernate.search.backend.elasticsearch.impl.ElasticsearchLinkImpl;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.multitenancy.impl.DiscriminatorMultiTenancyStrategy;
import org.hibernate.search.backend.elasticsearch.multitenancy.impl.MultiTenancyStrategy;
import org.hibernate.search.backend.elasticsearch.multitenancy.impl.NoMultiTenancyStrategy;
import org.hibernate.search.backend.elasticsearch.types.dsl.provider.impl.ElasticsearchIndexFieldTypeFactoryContextProvider;
import org.hibernate.search.engine.backend.spi.BackendBuildContext;
import org.hibernate.search.engine.backend.spi.BackendFactory;
import org.hibernate.search.engine.backend.spi.BackendImplementor;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.cfg.spi.OptionalConfigurationProperty;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanProvider;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.impl.SuppressingCloser;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

public class ElasticsearchBackendFactory
implements BackendFactory {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final OptionalConfigurationProperty<ElasticsearchVersion> VERSION = ConfigurationProperty.forKey((String)"version").as(ElasticsearchVersion.class, ElasticsearchVersion::of).build();
    private static final ConfigurationProperty<MultiTenancyStrategyName> MULTI_TENANCY_STRATEGY = ConfigurationProperty.forKey((String)"multi_tenancy_strategy").as(MultiTenancyStrategyName.class, MultiTenancyStrategyName::of).withDefault((Object)ElasticsearchBackendSettings.Defaults.MULTI_TENANCY_STRATEGY).build();
    private static final ConfigurationProperty<Boolean> LOG_JSON_PRETTY_PRINTING = ConfigurationProperty.forKey((String)"log.json_pretty_printing").asBoolean().withDefault((Object)false).build();
    private static final ConfigurationProperty<BeanReference<? extends ElasticsearchClientFactory>> CLIENT_FACTORY = ConfigurationProperty.forKey((String)"client_factory").asBeanReference(ElasticsearchClientFactory.class).withDefault(ElasticsearchBackendSpiSettings.Defaults.CLIENT_FACTORY).build();
    private static final OptionalConfigurationProperty<BeanReference<? extends ElasticsearchAnalysisConfigurer>> ANALYSIS_CONFIGURER = ConfigurationProperty.forKey((String)"analysis_configurer").asBeanReference(ElasticsearchAnalysisConfigurer.class).build();

    public BackendImplementor<?> create(String name, BackendBuildContext buildContext, ConfigurationPropertySource propertySource) {
        EventContext backendContext = EventContexts.fromBackendName((String)name);
        boolean logPrettyPrinting = (Boolean)LOG_JSON_PRETTY_PRINTING.get(propertySource);
        GsonProvider defaultGsonProvider = DefaultGsonProvider.create(GsonBuilder::new, logPrettyPrinting);
        Optional configuredVersion = (Optional)VERSION.get(propertySource);
        BeanProvider beanProvider = buildContext.getBeanProvider();
        BeanHolder clientFactoryHolder = null;
        ElasticsearchLinkImpl link = null;
        try {
            ElasticsearchVersion version;
            clientFactoryHolder = (BeanHolder)CLIENT_FACTORY.getAndTransform(propertySource, arg_0 -> ((BeanProvider)beanProvider).getBean(arg_0));
            ElasticsearchDialectFactory dialectFactory = new ElasticsearchDialectFactory();
            link = new ElasticsearchLinkImpl((BeanHolder<? extends ElasticsearchClientFactory>)clientFactoryHolder, defaultGsonProvider, logPrettyPrinting, dialectFactory, configuredVersion);
            if (configuredVersion.isPresent()) {
                version = (ElasticsearchVersion)configuredVersion.get();
            } else {
                link.onStart(propertySource);
                version = link.getElasticsearchVersion();
            }
            ElasticsearchModelDialect dialect = dialectFactory.createModelDialect(version);
            Gson userFacingGson = new GsonBuilder().setPrettyPrinting().create();
            ElasticsearchIndexFieldTypeFactoryContextProvider typeFactoryContextProvider = dialect.createIndexTypeFieldFactoryContextProvider(userFacingGson);
            ElasticsearchAnalysisDefinitionRegistry analysisDefinitionRegistry = this.getAnalysisDefinitionRegistry(backendContext, buildContext, propertySource);
            return new ElasticsearchBackendImpl(link, name, typeFactoryContextProvider, userFacingGson, analysisDefinitionRegistry, this.getMultiTenancyStrategy(name, propertySource));
        }
        catch (RuntimeException e) {
            ((SuppressingCloser)new SuppressingCloser((Throwable)e).push(BeanHolder::close, clientFactoryHolder)).push(ElasticsearchLinkImpl::onStop, link);
            throw e;
        }
    }

    private MultiTenancyStrategy getMultiTenancyStrategy(String backendName, ConfigurationPropertySource propertySource) {
        MultiTenancyStrategyName multiTenancyStrategyName = (MultiTenancyStrategyName)((Object)MULTI_TENANCY_STRATEGY.get(propertySource));
        switch (multiTenancyStrategyName) {
            case NONE: {
                return new NoMultiTenancyStrategy();
            }
            case DISCRIMINATOR: {
                return new DiscriminatorMultiTenancyStrategy();
            }
        }
        throw new AssertionFailure(String.format(Locale.ROOT, "Unsupported multi-tenancy strategy '%2$s' for backend '%1$s'", new Object[]{backendName, multiTenancyStrategyName}));
    }

    private ElasticsearchAnalysisDefinitionRegistry getAnalysisDefinitionRegistry(EventContext backendContext, BackendBuildContext buildContext, ConfigurationPropertySource propertySource) {
        try {
            BeanProvider beanProvider = buildContext.getBeanProvider();
            return ANALYSIS_CONFIGURER.getAndMap(propertySource, arg_0 -> ((BeanProvider)beanProvider).getBean(arg_0)).map(holder -> {
                try (BeanHolder configurerHolder = holder;){
                    ElasticsearchAnalysisDefinitionContainerContextImpl collector = new ElasticsearchAnalysisDefinitionContainerContextImpl();
                    ((ElasticsearchAnalysisConfigurer)configurerHolder.get()).configure(collector);
                    ElasticsearchAnalysisDefinitionRegistry elasticsearchAnalysisDefinitionRegistry = new ElasticsearchAnalysisDefinitionRegistry(collector);
                    return elasticsearchAnalysisDefinitionRegistry;
                }
            }).orElseGet(ElasticsearchAnalysisDefinitionRegistry::new);
        }
        catch (Exception e) {
            throw log.unableToApplyAnalysisConfiguration(e.getMessage(), backendContext, e);
        }
    }
}

