/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.index.impl;

import org.hibernate.search.backend.elasticsearch.document.impl.ElasticsearchDocumentObjectBuilder;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexModel;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.ElasticsearchIndexAdministrationClient;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.IndexMetadata;
import org.hibernate.search.backend.elasticsearch.index.impl.ElasticsearchIndexDocumentWorkExecutor;
import org.hibernate.search.backend.elasticsearch.index.impl.ElasticsearchIndexWorkExecutor;
import org.hibernate.search.backend.elasticsearch.index.impl.ElasticsearchIndexWorkPlan;
import org.hibernate.search.backend.elasticsearch.link.impl.ElasticsearchLink;
import org.hibernate.search.backend.elasticsearch.multitenancy.impl.MultiTenancyStrategy;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchWorkOrchestrator;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchWorkOrchestratorImplementor;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchWorkOrchestratorProvider;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.engine.backend.index.DocumentRefreshStrategy;
import org.hibernate.search.engine.backend.index.spi.IndexDocumentWorkExecutor;
import org.hibernate.search.engine.backend.index.spi.IndexWorkExecutor;
import org.hibernate.search.engine.backend.index.spi.IndexWorkPlan;
import org.hibernate.search.engine.mapper.session.context.spi.SessionContextImplementor;
import org.hibernate.search.util.common.reporting.EventContext;

public class IndexingBackendContext {
    private final EventContext eventContext;
    private final ElasticsearchLink link;
    private final MultiTenancyStrategy multiTenancyStrategy;
    private final ElasticsearchWorkOrchestratorProvider orchestratorProvider;

    public IndexingBackendContext(EventContext eventContext, ElasticsearchLink link, MultiTenancyStrategy multiTenancyStrategy, ElasticsearchWorkOrchestratorProvider orchestratorProvider) {
        this.eventContext = eventContext;
        this.link = link;
        this.multiTenancyStrategy = multiTenancyStrategy;
        this.orchestratorProvider = orchestratorProvider;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.eventContext + "]";
    }

    EventContext getEventContext() {
        return this.eventContext;
    }

    ElasticsearchIndexAdministrationClient createAdministrationClient(URLEncodedString indexName, ElasticsearchIndexModel model) {
        IndexMetadata metadata = new IndexMetadata();
        metadata.setName(model.getElasticsearchIndexName());
        metadata.setSettings(model.getSettings());
        metadata.setMapping(model.getMapping());
        return new ElasticsearchIndexAdministrationClient(this.link, this.orchestratorProvider.getRootParallelOrchestrator(), indexName, metadata);
    }

    ElasticsearchWorkOrchestratorImplementor createSerialOrchestrator(String indexName) {
        return this.orchestratorProvider.createSerialOrchestrator("Elasticsearch serial work orchestrator for index " + indexName);
    }

    ElasticsearchWorkOrchestratorImplementor createParallelOrchestrator(String indexName) {
        return this.orchestratorProvider.createParallelOrchestrator("Elasticsearch parallel work orchestrator for index " + indexName);
    }

    IndexWorkPlan<ElasticsearchDocumentObjectBuilder> createWorkPlan(ElasticsearchWorkOrchestrator orchestrator, URLEncodedString indexName, DocumentRefreshStrategy refreshStrategy, SessionContextImplementor sessionContext) {
        this.multiTenancyStrategy.checkTenantId(sessionContext.getTenantIdentifier(), this.eventContext);
        return new ElasticsearchIndexWorkPlan(this.link.getWorkBuilderFactory(), this.multiTenancyStrategy, orchestrator, indexName, refreshStrategy, sessionContext);
    }

    IndexDocumentWorkExecutor<ElasticsearchDocumentObjectBuilder> createDocumentWorkExecutor(ElasticsearchWorkOrchestrator orchestrator, URLEncodedString indexName, SessionContextImplementor sessionContext) {
        this.multiTenancyStrategy.checkTenantId(sessionContext.getTenantIdentifier(), this.eventContext);
        return new ElasticsearchIndexDocumentWorkExecutor(this.link.getWorkBuilderFactory(), this.multiTenancyStrategy, orchestrator, indexName, sessionContext);
    }

    IndexWorkExecutor createWorkExecutor(ElasticsearchWorkOrchestrator orchestrator, URLEncodedString indexName) {
        return new ElasticsearchIndexWorkExecutor(this.link.getWorkBuilderFactory(), this.multiTenancyStrategy, orchestrator, indexName, this.eventContext);
    }
}

