/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.orchestration.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchWorkOrchestratorImplementor;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchWorkProcessor;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchWork;
import org.hibernate.search.engine.backend.orchestration.spi.AbstractWorkOrchestrator;
import org.hibernate.search.engine.backend.orchestration.spi.BatchingExecutor;
import org.hibernate.search.util.common.impl.Futures;

abstract class AbstractElasticsearchWorkOrchestrator
extends AbstractWorkOrchestrator<ElasticsearchWorkSet>
implements ElasticsearchWorkOrchestratorImplementor {
    AbstractElasticsearchWorkOrchestrator(String name) {
        super(name);
    }

    @Override
    public CompletableFuture<?> submit(List<ElasticsearchWork<?>> works) {
        CompletableFuture<Object> future = new CompletableFuture<Object>();
        this.submit(new ElasticsearchMultipleWorkSet(works, future));
        return future;
    }

    @Override
    public <T> CompletableFuture<T> submit(ElasticsearchWork<T> work) {
        CompletableFuture future = new CompletableFuture();
        this.submit(new ElasticsearchSingleWorkSet<T>(work, future));
        return future;
    }

    static class ElasticsearchSingleWorkSet<T>
    implements ElasticsearchWorkSet {
        private final ElasticsearchWork<T> work;
        private final CompletableFuture<T> future;

        ElasticsearchSingleWorkSet(ElasticsearchWork<T> work, CompletableFuture<T> future) {
            this.work = work;
            this.future = future;
        }

        public void submitTo(ElasticsearchWorkProcessor delegate) {
            delegate.submit(this.work).whenComplete(Futures.copyHandler(this.future));
        }

        public void markAsFailed(Throwable t) {
            this.future.completeExceptionally(t);
        }
    }

    static class ElasticsearchMultipleWorkSet
    implements ElasticsearchWorkSet {
        private final List<ElasticsearchWork<?>> works;
        private final CompletableFuture<Object> future;

        ElasticsearchMultipleWorkSet(List<ElasticsearchWork<?>> works, CompletableFuture<Object> future) {
            this.works = new ArrayList(works);
            this.future = future;
        }

        public void submitTo(ElasticsearchWorkProcessor delegate) {
            delegate.submit(this.works).whenComplete(Futures.copyHandler(this.future));
        }

        public void markAsFailed(Throwable t) {
            this.future.completeExceptionally(t);
        }
    }

    static interface ElasticsearchWorkSet
    extends BatchingExecutor.WorkSet<ElasticsearchWorkProcessor> {
    }
}

