/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.orchestration.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchWorkBulker;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchWorkSequenceBuilder;
import org.hibernate.search.backend.elasticsearch.work.impl.BulkableElasticsearchWork;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchWork;
import org.hibernate.search.backend.elasticsearch.work.result.impl.BulkResult;
import org.hibernate.search.engine.backend.index.DocumentRefreshStrategy;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.impl.Futures;

class ElasticsearchDefaultWorkBulker
implements ElasticsearchWorkBulker {
    private final ElasticsearchWorkSequenceBuilder sequenceBuilder;
    private final BiFunction<List<? extends BulkableElasticsearchWork<?>>, DocumentRefreshStrategy, ElasticsearchWork<BulkResult>> bulkWorkFactory;
    private final int minBulkSize;
    private final int maxBulkSize;
    private final List<BulkableElasticsearchWork<?>> currentBulkItems;
    private final List<CompletableFuture<?>> currentBulkItemsFutures;
    private int currentBulkFirstNonAddedItem;
    private DocumentRefreshStrategy currentBulkRefreshStrategy;
    private CompletableFuture<ElasticsearchWork<BulkResult>> currentBulkWorkFuture;
    private CompletableFuture<BulkResult> currentBulkResultFuture;

    public ElasticsearchDefaultWorkBulker(ElasticsearchWorkSequenceBuilder sequenceBuilder, BiFunction<List<? extends BulkableElasticsearchWork<?>>, DocumentRefreshStrategy, ElasticsearchWork<BulkResult>> bulkWorkFactory, int minBulkSize, int maxBulkSize) {
        this.sequenceBuilder = sequenceBuilder;
        this.bulkWorkFactory = bulkWorkFactory;
        this.minBulkSize = minBulkSize;
        this.maxBulkSize = maxBulkSize;
        this.currentBulkItems = new ArrayList();
        this.currentBulkItemsFutures = new ArrayList();
        this.currentBulkFirstNonAddedItem = 0;
        this.currentBulkWorkFuture = null;
        this.currentBulkResultFuture = null;
    }

    @Override
    public <T> CompletableFuture<T> add(BulkableElasticsearchWork<T> work) {
        DocumentRefreshStrategy workRefreshStrategy = work.getRefreshStrategy();
        if (this.currentBulkItems.isEmpty()) {
            this.currentBulkRefreshStrategy = workRefreshStrategy;
        } else if (this.currentBulkRefreshStrategy != workRefreshStrategy) {
            this.addWorksToSequence();
            this.finalizeBulkWork();
            this.currentBulkRefreshStrategy = workRefreshStrategy;
        }
        CompletableFuture future = new CompletableFuture();
        this.currentBulkItems.add(work);
        this.currentBulkItemsFutures.add(future);
        if (this.currentBulkItems.size() >= this.maxBulkSize) {
            this.addWorksToSequence();
            this.finalizeBulkWork();
        }
        return future;
    }

    @Override
    public boolean addWorksToSequence() {
        int currentBulkWorksSize = this.currentBulkItems.size();
        if (currentBulkWorksSize <= this.currentBulkFirstNonAddedItem) {
            return false;
        }
        if (currentBulkWorksSize < this.minBulkSize && this.currentBulkFirstNonAddedItem == 0) {
            for (int i = 0; i < currentBulkWorksSize; ++i) {
                BulkableElasticsearchWork<?> work = this.currentBulkItems.get(i);
                this.addAndConnectNonBulkedWorkExecution(work, i);
            }
            this.reset();
            return false;
        }
        if (this.currentBulkWorkFuture == null) {
            this.currentBulkWorkFuture = new CompletableFuture();
            this.currentBulkResultFuture = this.sequenceBuilder.addBulkExecution(this.currentBulkWorkFuture);
        }
        ElasticsearchWorkSequenceBuilder.BulkResultExtractionStep extractionStep = this.sequenceBuilder.addBulkResultExtraction(this.currentBulkResultFuture);
        for (int i = this.currentBulkFirstNonAddedItem; i < currentBulkWorksSize; ++i) {
            BulkableElasticsearchWork<?> work = this.currentBulkItems.get(i);
            this.addAndConnectBulkedWorkExtraction(extractionStep, work, i);
        }
        this.currentBulkFirstNonAddedItem = currentBulkWorksSize;
        return true;
    }

    @Override
    public void finalizeBulkWork() {
        if (this.currentBulkItems.size() != this.currentBulkFirstNonAddedItem) {
            throw new AssertionFailure("Some works haven't been added to the sequence builder");
        }
        if (this.currentBulkWorkFuture == null) {
            return;
        }
        ElasticsearchWork<BulkResult> bulkWork = this.bulkWorkFactory.apply(this.currentBulkItems, this.currentBulkRefreshStrategy);
        this.currentBulkWorkFuture.complete(bulkWork);
        this.reset();
    }

    @Override
    public void reset() {
        this.currentBulkItems.clear();
        this.currentBulkItemsFutures.clear();
        this.currentBulkFirstNonAddedItem = 0;
        this.currentBulkRefreshStrategy = null;
        this.currentBulkWorkFuture = null;
        this.currentBulkResultFuture = null;
    }

    private <T> void addAndConnectNonBulkedWorkExecution(BulkableElasticsearchWork<T> work, int index) {
        CompletableFuture<?> future = this.currentBulkItemsFutures.get(index);
        this.sequenceBuilder.addNonBulkExecution(work).whenComplete(Futures.copyHandler(future));
    }

    private <T> void addAndConnectBulkedWorkExtraction(ElasticsearchWorkSequenceBuilder.BulkResultExtractionStep extractionStep, BulkableElasticsearchWork<T> work, int index) {
        CompletableFuture<?> future = this.currentBulkItemsFutures.get(index);
        extractionStep.add(work, index).whenComplete(Futures.copyHandler(future));
    }
}

