/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.orchestration.impl;

import java.util.List;
import java.util.function.Supplier;
import org.hibernate.search.backend.elasticsearch.link.impl.ElasticsearchLink;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchBatchingWorkOrchestrator;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchDefaultWorkBulker;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchDefaultWorkExecutionContext;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchDefaultWorkSequenceBuilder;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchParallelWorkProcessor;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchRefreshableWorkExecutionContext;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchSerialWorkProcessor;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchWorkBulker;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchWorkOrchestratorImplementor;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchWorkProcessor;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchWorkSequenceBuilder;
import org.hibernate.search.backend.elasticsearch.work.impl.BulkableElasticsearchWork;
import org.hibernate.search.engine.backend.index.DocumentRefreshStrategy;
import org.hibernate.search.engine.common.spi.ErrorHandler;

public class ElasticsearchWorkOrchestratorProvider
implements AutoCloseable {
    private static final int SERIAL_MIN_BULK_SIZE = 2;
    private static final int PARALLEL_MIN_BULK_SIZE = 1;
    private static final int MAX_BULK_SIZE = 250;
    private static final int SERIAL_MAX_WORKSETS_PER_BATCH = 2500;
    private static final int PARALLEL_MAX_WORKSETS_PER_BATCH = 5000;
    private final ElasticsearchLink link;
    private final ErrorHandler errorHandler;
    private final ElasticsearchBatchingWorkOrchestrator rootParallelOrchestrator;

    public ElasticsearchWorkOrchestratorProvider(String rootParallelOrchestratorName, ElasticsearchLink link, ErrorHandler errorHandler) {
        this.link = link;
        this.errorHandler = errorHandler;
        this.rootParallelOrchestrator = this.createBatchingSharedOrchestrator(rootParallelOrchestratorName, this.createParallelWorkProcessor(), 5000, false);
    }

    @Override
    public void close() {
        this.rootParallelOrchestrator.close();
    }

    public void start() {
        this.rootParallelOrchestrator.start();
    }

    public ElasticsearchBatchingWorkOrchestrator getRootParallelOrchestrator() {
        return this.rootParallelOrchestrator;
    }

    public ElasticsearchWorkOrchestratorImplementor createSerialOrchestrator(String name) {
        ElasticsearchWorkProcessor processor = this.createSerialWorkProcessor();
        return this.createBatchingSharedOrchestrator(name, processor, 2500, true);
    }

    public ElasticsearchWorkOrchestratorImplementor createParallelOrchestrator(String name) {
        return this.rootParallelOrchestrator.createChild(name);
    }

    private ElasticsearchBatchingWorkOrchestrator createBatchingSharedOrchestrator(String name, ElasticsearchWorkProcessor processor, int maxWorksetsPerBatch, boolean fair) {
        return new ElasticsearchBatchingWorkOrchestrator(name, processor, maxWorksetsPerBatch, fair, this.errorHandler);
    }

    private ElasticsearchWorkProcessor createSerialWorkProcessor() {
        ElasticsearchWorkSequenceBuilder sequenceBuilder = this.createSequenceBuilder(this::createRefreshingWorkExecutionContext);
        ElasticsearchWorkBulker bulker = this.createBulker(sequenceBuilder, 2);
        return new ElasticsearchSerialWorkProcessor(sequenceBuilder, bulker);
    }

    private ElasticsearchWorkProcessor createParallelWorkProcessor() {
        ElasticsearchWorkSequenceBuilder sequenceBuilder = this.createSequenceBuilder(this::createRefreshingWorkExecutionContext);
        ElasticsearchWorkBulker bulker = this.createBulker(sequenceBuilder, 1);
        return new ElasticsearchParallelWorkProcessor(sequenceBuilder, bulker);
    }

    private ElasticsearchWorkSequenceBuilder createSequenceBuilder(Supplier<ElasticsearchRefreshableWorkExecutionContext> contextSupplier) {
        return new ElasticsearchDefaultWorkSequenceBuilder(contextSupplier, () -> ((ErrorHandler)this.errorHandler).createContextualHandler());
    }

    private ElasticsearchWorkBulker createBulker(ElasticsearchWorkSequenceBuilder sequenceBuilder, int minBulkSize) {
        return new ElasticsearchDefaultWorkBulker(sequenceBuilder, (worksToBulk, refreshStrategy) -> this.link.getWorkBuilderFactory().bulk((List<? extends BulkableElasticsearchWork<?>>)worksToBulk).refresh((DocumentRefreshStrategy)refreshStrategy).build(), minBulkSize, 250);
    }

    private ElasticsearchRefreshableWorkExecutionContext createRefreshingWorkExecutionContext() {
        return new ElasticsearchDefaultWorkExecutionContext(this.link.getClient(), this.link.getGsonProvider(), this.link.getWorkBuilderFactory(), this.errorHandler);
    }
}

