/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.projection.impl;

import com.google.gson.JsonObject;
import java.util.function.BiFunction;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchCompositeProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchSearchProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.SearchProjectionExtractContext;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.SearchProjectionTransformContext;
import org.hibernate.search.engine.search.loading.spi.LoadingResult;
import org.hibernate.search.engine.search.loading.spi.ProjectionHitMapper;

public class ElasticsearchCompositeBiFunctionProjection<P1, P2, P>
implements ElasticsearchCompositeProjection<Object[], P> {
    private final BiFunction<P1, P2, P> transformer;
    private final ElasticsearchSearchProjection<?, P1> projection1;
    private final ElasticsearchSearchProjection<?, P2> projection2;

    public ElasticsearchCompositeBiFunctionProjection(BiFunction<P1, P2, P> transformer, ElasticsearchSearchProjection<?, P1> projection1, ElasticsearchSearchProjection<?, P2> projection2) {
        this.transformer = transformer;
        this.projection1 = projection1;
        this.projection2 = projection2;
    }

    @Override
    public void contributeRequest(JsonObject requestBody, SearchProjectionExtractContext context) {
        this.projection1.contributeRequest(requestBody, context);
        this.projection2.contributeRequest(requestBody, context);
    }

    @Override
    public Object[] extract(ProjectionHitMapper<?, ?> projectionHitMapper, JsonObject responseBody, JsonObject hit, SearchProjectionExtractContext context) {
        return new Object[]{this.projection1.extract(projectionHitMapper, responseBody, hit, context), this.projection2.extract(projectionHitMapper, responseBody, hit, context)};
    }

    @Override
    public P transform(LoadingResult<?> loadingResult, Object[] extractedData, SearchProjectionTransformContext context) {
        return this.transformer.apply(ElasticsearchSearchProjection.transformUnsafe(this.projection1, loadingResult, extractedData[0], context), ElasticsearchSearchProjection.transformUnsafe(this.projection2, loadingResult, extractedData[1], context));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("[").append("projection1=").append(this.projection1).append(", projection2=").append(this.projection2).append("]");
        return sb.toString();
    }
}

