/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.projection.impl;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchCompositeProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchSearchProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.SearchProjectionExtractContext;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.SearchProjectionTransformContext;
import org.hibernate.search.engine.search.loading.spi.LoadingResult;
import org.hibernate.search.engine.search.loading.spi.ProjectionHitMapper;

public class ElasticsearchCompositeListProjection<P>
implements ElasticsearchCompositeProjection<List<Object>, P> {
    private final Function<List<?>, P> transformer;
    private final List<ElasticsearchSearchProjection<?, ?>> children;

    public ElasticsearchCompositeListProjection(Function<List<?>, P> transformer, List<ElasticsearchSearchProjection<?, ?>> children) {
        this.transformer = transformer;
        this.children = children;
    }

    @Override
    public void contributeRequest(JsonObject requestBody, SearchProjectionExtractContext context) {
        for (ElasticsearchSearchProjection<?, ?> child : this.children) {
            child.contributeRequest(requestBody, context);
        }
    }

    @Override
    public List<Object> extract(ProjectionHitMapper<?, ?> projectionHitMapper, JsonObject responseBody, JsonObject hit, SearchProjectionExtractContext context) {
        ArrayList<Object> extractedData = new ArrayList<Object>(this.children.size());
        for (ElasticsearchSearchProjection<?, ?> child : this.children) {
            extractedData.add(child.extract(projectionHitMapper, responseBody, hit, context));
        }
        return extractedData;
    }

    @Override
    public P transform(LoadingResult<?> loadingResult, List<Object> extractedData, SearchProjectionTransformContext context) {
        for (int i = 0; i < extractedData.size(); ++i) {
            extractedData.set(i, ElasticsearchSearchProjection.transformUnsafe(this.children.get(i), loadingResult, extractedData.get(i), context));
        }
        return this.transformer.apply(extractedData);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("[").append("children=").append(this.children).append("]");
        return sb.toString();
    }
}

