/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.projection.impl;

import com.google.gson.JsonObject;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchCompositeProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchSearchProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.SearchProjectionExtractContext;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.SearchProjectionTransformContext;
import org.hibernate.search.engine.search.loading.spi.LoadingResult;
import org.hibernate.search.engine.search.loading.spi.ProjectionHitMapper;
import org.hibernate.search.util.common.function.TriFunction;

public class ElasticsearchCompositeTriFunctionProjection<P1, P2, P3, P>
implements ElasticsearchCompositeProjection<Object[], P> {
    private final TriFunction<P1, P2, P3, P> transformer;
    private final ElasticsearchSearchProjection<?, P1> projection1;
    private final ElasticsearchSearchProjection<?, P2> projection2;
    private final ElasticsearchSearchProjection<?, P3> projection3;

    public ElasticsearchCompositeTriFunctionProjection(TriFunction<P1, P2, P3, P> transformer, ElasticsearchSearchProjection<?, P1> projection1, ElasticsearchSearchProjection<?, P2> projection2, ElasticsearchSearchProjection<?, P3> projection3) {
        this.transformer = transformer;
        this.projection1 = projection1;
        this.projection2 = projection2;
        this.projection3 = projection3;
    }

    @Override
    public void contributeRequest(JsonObject requestBody, SearchProjectionExtractContext context) {
        this.projection1.contributeRequest(requestBody, context);
        this.projection2.contributeRequest(requestBody, context);
        this.projection3.contributeRequest(requestBody, context);
    }

    @Override
    public Object[] extract(ProjectionHitMapper<?, ?> projectionHitMapper, JsonObject responseBody, JsonObject hit, SearchProjectionExtractContext context) {
        return new Object[]{this.projection1.extract(projectionHitMapper, responseBody, hit, context), this.projection2.extract(projectionHitMapper, responseBody, hit, context), this.projection3.extract(projectionHitMapper, responseBody, hit, context)};
    }

    @Override
    public P transform(LoadingResult<?> loadingResult, Object[] extractedData, SearchProjectionTransformContext context) {
        return (P)this.transformer.apply(ElasticsearchSearchProjection.transformUnsafe(this.projection1, loadingResult, extractedData[0], context), ElasticsearchSearchProjection.transformUnsafe(this.projection2, loadingResult, extractedData[1], context), ElasticsearchSearchProjection.transformUnsafe(this.projection3, loadingResult, extractedData[2], context));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("[").append("projection1=").append(this.projection1).append(", projection2=").append(this.projection2).append(", projection3=").append(this.projection3).append("]");
        return sb.toString();
    }
}

