/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.projection.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Optional;
import java.util.regex.Pattern;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonArrayAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonObjectAccessor;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchSearchProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.SearchProjectionExtractContext;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.SearchProjectionTransformContext;
import org.hibernate.search.engine.search.loading.spi.LoadingResult;
import org.hibernate.search.engine.search.loading.spi.ProjectionHitMapper;
import org.hibernate.search.engine.spatial.DistanceUnit;
import org.hibernate.search.engine.spatial.GeoPoint;

class ElasticsearchDistanceToFieldProjection
implements ElasticsearchSearchProjection<Double, Double> {
    private static final JsonObjectAccessor SCRIPT_FIELDS_ACCESSOR = JsonAccessor.root().property("script_fields").asObject();
    private static final JsonObjectAccessor FIELDS_ACCESSOR = JsonAccessor.root().property("fields").asObject();
    private static final JsonArrayAccessor SCORE_ACCESSOR = JsonAccessor.root().property("sort").asArray();
    private static final Pattern NON_DIGITS_PATTERN = Pattern.compile("\\D");
    private final String absoluteFieldPath;
    private final GeoPoint center;
    private final DistanceUnit unit;
    private final String scriptFieldName;

    ElasticsearchDistanceToFieldProjection(String absoluteFieldPath, GeoPoint center, DistanceUnit unit) {
        this.absoluteFieldPath = absoluteFieldPath;
        this.center = center;
        this.unit = unit;
        this.scriptFieldName = ElasticsearchDistanceToFieldProjection.createScriptFieldName(absoluteFieldPath, center, unit);
    }

    @Override
    public void contributeRequest(JsonObject requestBody, SearchProjectionExtractContext context) {
        if (context.getDistanceSortIndex(this.absoluteFieldPath, this.center) == null) {
            SCRIPT_FIELDS_ACCESSOR.property(this.scriptFieldName).asObject().property("script").asObject().set(requestBody, ElasticsearchDistanceToFieldProjection.createScript(this.absoluteFieldPath, this.center));
        }
    }

    @Override
    public Double extract(ProjectionHitMapper<?, ?> projectionHitMapper, JsonObject responseBody, JsonObject hit, SearchProjectionExtractContext context) {
        Optional scoreDistanceElement;
        Integer distanceSortIndex = context.getDistanceSortIndex(this.absoluteFieldPath, this.center);
        Optional<Object> distance = distanceSortIndex == null ? FIELDS_ACCESSOR.property(this.scriptFieldName).asArray().element(0).asDouble().get(hit) : (!(scoreDistanceElement = SCORE_ACCESSOR.element(distanceSortIndex).get(hit)).isPresent() ? Optional.empty() : (!((JsonElement)scoreDistanceElement.get()).getAsJsonPrimitive().isNumber() ? Optional.empty() : Optional.of(((JsonElement)scoreDistanceElement.get()).getAsJsonPrimitive().getAsDouble())));
        return distance.isPresent() && Double.isFinite(distance.get()) ? this.unit.fromMeters(distance.get()) : null;
    }

    @Override
    public Double transform(LoadingResult<?> loadingResult, Double extractedData, SearchProjectionTransformContext context) {
        return extractedData;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("[").append("absoluteFieldPath=").append(this.absoluteFieldPath).append(", center=").append(this.center).append(", unit=").append(this.unit).append("]");
        return sb.toString();
    }

    private static String createScriptFieldName(String absoluteFieldPath, GeoPoint center, DistanceUnit unit) {
        StringBuilder sb = new StringBuilder();
        sb.append("distance_").append(absoluteFieldPath).append("_").append(NON_DIGITS_PATTERN.matcher(Double.toString(center.getLatitude())).replaceAll("_")).append("_").append(NON_DIGITS_PATTERN.matcher(Double.toString(center.getLongitude())).replaceAll("_")).append("_").append(unit.name());
        return sb.toString();
    }

    private static JsonObject createScript(String absoluteFieldPath, GeoPoint center) {
        JsonObject jsonCenter = new JsonObject();
        jsonCenter.addProperty("lat", (Number)center.getLatitude());
        jsonCenter.addProperty("lon", (Number)center.getLongitude());
        JsonObject scriptContent = new JsonObject();
        scriptContent.addProperty("lang", "painless");
        scriptContent.add("params", (JsonElement)jsonCenter);
        scriptContent.addProperty("source", "doc['" + absoluteFieldPath + "'].size() != 0 ? doc['" + absoluteFieldPath + "'].arcDistance(params.lat, params.lon) : null");
        return scriptContent;
    }
}

