/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.projection.impl;

import com.google.gson.JsonObject;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchSearchProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.SearchProjectionExtractContext;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.SearchProjectionTransformContext;
import org.hibernate.search.engine.search.loading.spi.LoadingResult;
import org.hibernate.search.engine.search.loading.spi.ProjectionHitMapper;

class ElasticsearchScoreProjection
implements ElasticsearchSearchProjection<Float, Float> {
    private static final JsonAccessor<Boolean> TRACK_SCORES_ACCESSOR = JsonAccessor.root().property("track_scores").asBoolean();

    ElasticsearchScoreProjection() {
    }

    @Override
    public void contributeRequest(JsonObject requestBody, SearchProjectionExtractContext context) {
        TRACK_SCORES_ACCESSOR.set(requestBody, true);
    }

    @Override
    public Float extract(ProjectionHitMapper<?, ?> projectionHitMapper, JsonObject responseBody, JsonObject hit, SearchProjectionExtractContext context) {
        return Float.valueOf(hit.get("_score").getAsFloat());
    }

    @Override
    public Float transform(LoadingResult<?> loadingResult, Float extractedData, SearchProjectionTransformContext context) {
        return extractedData;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

