/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.query.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.search.backend.elasticsearch.multitenancy.impl.MultiTenancyStrategy;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchWorkOrchestrator;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchContext;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchQueryElementCollector;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchSearchProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.SearchProjectionExtractContext;
import org.hibernate.search.backend.elasticsearch.search.query.ElasticsearchSearchQuery;
import org.hibernate.search.backend.elasticsearch.search.query.impl.ElasticsearchSearchQueryImpl;
import org.hibernate.search.backend.elasticsearch.search.query.impl.ElasticsearchSearchResultExtractorFactory;
import org.hibernate.search.backend.elasticsearch.work.builder.factory.impl.ElasticsearchWorkBuilderFactory;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchSearchResultExtractor;
import org.hibernate.search.engine.mapper.session.context.spi.SessionContextImplementor;
import org.hibernate.search.engine.search.loading.context.spi.LoadingContext;
import org.hibernate.search.engine.search.loading.context.spi.LoadingContextBuilder;
import org.hibernate.search.engine.search.query.spi.SearchQueryBuilder;

public class ElasticsearchSearchQueryBuilder<H>
implements SearchQueryBuilder<H, ElasticsearchSearchQueryElementCollector> {
    private final ElasticsearchWorkBuilderFactory workFactory;
    private final ElasticsearchSearchResultExtractorFactory searchResultExtractorFactory;
    private final ElasticsearchWorkOrchestrator queryOrchestrator;
    private final MultiTenancyStrategy multiTenancyStrategy;
    private final ElasticsearchSearchContext searchContext;
    private final SessionContextImplementor sessionContext;
    private final Set<String> routingKeys;
    private final ElasticsearchSearchQueryElementCollector elementCollector;
    private final LoadingContextBuilder<?, ?> loadingContextBuilder;
    private final ElasticsearchSearchProjection<?, H> rootProjection;

    ElasticsearchSearchQueryBuilder(ElasticsearchWorkBuilderFactory workFactory, ElasticsearchSearchResultExtractorFactory searchResultExtractorFactory, ElasticsearchWorkOrchestrator queryOrchestrator, MultiTenancyStrategy multiTenancyStrategy, ElasticsearchSearchContext searchContext, SessionContextImplementor sessionContext, LoadingContextBuilder<?, ?> loadingContextBuilder, ElasticsearchSearchProjection<?, H> rootProjection) {
        this.workFactory = workFactory;
        this.searchResultExtractorFactory = searchResultExtractorFactory;
        this.queryOrchestrator = queryOrchestrator;
        this.multiTenancyStrategy = multiTenancyStrategy;
        this.searchContext = searchContext;
        this.sessionContext = sessionContext;
        this.routingKeys = new HashSet<String>();
        this.elementCollector = new ElasticsearchSearchQueryElementCollector(sessionContext);
        this.loadingContextBuilder = loadingContextBuilder;
        this.rootProjection = rootProjection;
    }

    public ElasticsearchSearchQueryElementCollector getQueryElementCollector() {
        return this.elementCollector;
    }

    public void addRoutingKey(String routingKey) {
        this.routingKeys.add(routingKey);
    }

    public ElasticsearchSearchQuery<H> build() {
        JsonArray jsonSort;
        JsonObject payload = new JsonObject();
        JsonObject jsonQuery = this.getJsonQuery();
        if (jsonQuery != null) {
            payload.add("query", (JsonElement)jsonQuery);
        }
        if ((jsonSort = this.elementCollector.toJsonSort()) != null) {
            payload.add("sort", (JsonElement)jsonSort);
        }
        SearchProjectionExtractContext searchProjectionExecutionContext = this.elementCollector.toSearchProjectionExecutionContext();
        this.rootProjection.contributeRequest(payload, searchProjectionExecutionContext);
        LoadingContext loadingContext = this.loadingContextBuilder.build();
        ElasticsearchSearchResultExtractor<H> searchResultExtractor = this.searchResultExtractorFactory.createResultExtractor(loadingContext, this.rootProjection, searchProjectionExecutionContext);
        return new ElasticsearchSearchQueryImpl<H>(this.workFactory, this.queryOrchestrator, this.searchContext, this.sessionContext, loadingContext, this.routingKeys, payload, searchResultExtractor);
    }

    private JsonObject getJsonQuery() {
        return this.multiTenancyStrategy.decorateJsonQuery(this.elementCollector.toJsonPredicate(), this.sessionContext.getTenantIdentifier());
    }
}

