/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.query.impl;

import com.google.gson.Gson;
import java.util.function.Function;
import org.hibernate.search.backend.elasticsearch.link.impl.ElasticsearchLink;
import org.hibernate.search.backend.elasticsearch.multitenancy.impl.MultiTenancyStrategy;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchWorkOrchestrator;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchContext;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchScopeModel;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.DocumentReferenceExtractorHelper;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchSearchProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.SearchProjectionBackendContext;
import org.hibernate.search.backend.elasticsearch.search.query.impl.ElasticsearchSearchQueryBuilder;
import org.hibernate.search.engine.mapper.mapping.context.spi.MappingContextImplementor;
import org.hibernate.search.engine.mapper.session.context.spi.SessionContextImplementor;
import org.hibernate.search.engine.search.loading.context.spi.LoadingContextBuilder;
import org.hibernate.search.util.common.reporting.EventContext;

public class SearchBackendContext {
    private final EventContext eventContext;
    private final ElasticsearchLink link;
    private final Gson userFacingGson;
    private final MultiTenancyStrategy multiTenancyStrategy;
    private final ElasticsearchWorkOrchestrator orchestrator;
    private final SearchProjectionBackendContext searchProjectionBackendContext;
    private final DocumentReferenceExtractorHelper documentReferenceExtractorHelper;

    public SearchBackendContext(EventContext eventContext, ElasticsearchLink link, Gson userFacingGson, Function<String, String> indexNameConverter, MultiTenancyStrategy multiTenancyStrategy, ElasticsearchWorkOrchestrator orchestrator) {
        this.eventContext = eventContext;
        this.link = link;
        this.userFacingGson = userFacingGson;
        this.multiTenancyStrategy = multiTenancyStrategy;
        this.orchestrator = orchestrator;
        this.documentReferenceExtractorHelper = new DocumentReferenceExtractorHelper(indexNameConverter, multiTenancyStrategy);
        this.searchProjectionBackendContext = new SearchProjectionBackendContext(this.documentReferenceExtractorHelper, userFacingGson);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.eventContext + "]";
    }

    public EventContext getEventContext() {
        return this.eventContext;
    }

    DocumentReferenceExtractorHelper getDocumentReferenceExtractorHelper() {
        return this.documentReferenceExtractorHelper;
    }

    SearchProjectionBackendContext getSearchProjectionBackendContext() {
        return this.searchProjectionBackendContext;
    }

    ElasticsearchSearchContext createSearchContext(MappingContextImplementor mappingContext, ElasticsearchSearchScopeModel scopeModel) {
        return new ElasticsearchSearchContext(mappingContext, this.userFacingGson, this.multiTenancyStrategy, scopeModel);
    }

    <H> ElasticsearchSearchQueryBuilder<H> createSearchQueryBuilder(ElasticsearchSearchContext searchContext, SessionContextImplementor sessionContext, LoadingContextBuilder<?, ?> loadingContextBuilder, ElasticsearchSearchProjection<?, H> rootProjection) {
        this.multiTenancyStrategy.checkTenantId(sessionContext.getTenantIdentifier(), this.eventContext);
        return new ElasticsearchSearchQueryBuilder<H>(this.link.getWorkBuilderFactory(), this.link.getSearchResultExtractorFactory(), this.orchestrator, this.multiTenancyStrategy, searchContext, sessionContext, loadingContextBuilder, rootProjection);
    }
}

