/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.dsl.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.lang.invoke.MethodHandles;
import org.hibernate.search.backend.elasticsearch.document.model.impl.esnative.DataType;
import org.hibernate.search.backend.elasticsearch.document.model.impl.esnative.PropertyMapping;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchStringFieldCodec;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.AbstractElasticsearchStandardIndexFieldTypeContext;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchIndexFieldTypeBuildContext;
import org.hibernate.search.backend.elasticsearch.types.impl.ElasticsearchIndexFieldType;
import org.hibernate.search.backend.elasticsearch.types.predicate.impl.ElasticsearchTextFieldPredicateBuilderFactory;
import org.hibernate.search.backend.elasticsearch.types.projection.impl.ElasticsearchStandardFieldProjectionBuilderFactory;
import org.hibernate.search.backend.elasticsearch.types.sort.impl.ElasticsearchStandardFieldSortBuilderFactory;
import org.hibernate.search.engine.backend.types.IndexFieldType;
import org.hibernate.search.engine.backend.types.Projectable;
import org.hibernate.search.engine.backend.types.Sortable;
import org.hibernate.search.engine.backend.types.converter.FromDocumentFieldValueConverter;
import org.hibernate.search.engine.backend.types.converter.ToDocumentFieldValueConverter;
import org.hibernate.search.engine.backend.types.dsl.StringIndexFieldTypeContext;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class ElasticsearchStringIndexFieldTypeContext
extends AbstractElasticsearchStandardIndexFieldTypeContext<ElasticsearchStringIndexFieldTypeContext, String>
implements StringIndexFieldTypeContext<ElasticsearchStringIndexFieldTypeContext> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private String analyzerName;
    private String normalizerName;
    private Projectable projectable = Projectable.DEFAULT;
    private Sortable sortable = Sortable.DEFAULT;
    private String indexNullAs;

    ElasticsearchStringIndexFieldTypeContext(ElasticsearchIndexFieldTypeBuildContext buildContext) {
        super(buildContext, String.class);
    }

    public ElasticsearchStringIndexFieldTypeContext analyzer(String analyzerName) {
        this.analyzerName = analyzerName;
        return this;
    }

    public ElasticsearchStringIndexFieldTypeContext normalizer(String normalizerName) {
        this.normalizerName = normalizerName;
        return this;
    }

    public ElasticsearchStringIndexFieldTypeContext projectable(Projectable projectable) {
        this.projectable = projectable;
        return this;
    }

    public ElasticsearchStringIndexFieldTypeContext sortable(Sortable sortable) {
        this.sortable = sortable;
        return this;
    }

    public ElasticsearchStringIndexFieldTypeContext indexNullAs(String indexNullAs) {
        this.indexNullAs = indexNullAs;
        return this;
    }

    public IndexFieldType<String> toIndexFieldType() {
        PropertyMapping mapping = new PropertyMapping();
        boolean resolvedSortable = ElasticsearchStringIndexFieldTypeContext.resolveDefault(this.sortable);
        boolean resolvedProjectable = ElasticsearchStringIndexFieldTypeContext.resolveDefault(this.projectable);
        mapping.setIndex(true);
        if (this.analyzerName != null) {
            mapping.setType(DataType.TEXT);
            mapping.setAnalyzer(this.analyzerName);
            if (this.normalizerName != null) {
                throw log.cannotApplyAnalyzerAndNormalizer(this.analyzerName, this.normalizerName, this.getBuildContext().getEventContext());
            }
            if (resolvedSortable) {
                throw log.cannotUseAnalyzerOnSortableField(this.analyzerName, this.getBuildContext().getEventContext());
            }
            if (this.indexNullAs != null) {
                throw log.cannotUseIndexNullAsAndAnalyzer(this.analyzerName, this.indexNullAs, this.getBuildContext().getEventContext());
            }
        } else {
            mapping.setType(DataType.KEYWORD);
            mapping.setNormalizer(this.normalizerName);
            mapping.setDocValues(resolvedSortable);
        }
        mapping.setStore(resolvedProjectable);
        if (this.indexNullAs != null) {
            mapping.setNullValue((JsonElement)new JsonPrimitive(this.indexNullAs));
        }
        ToDocumentFieldValueConverter dslToIndexConverter = this.createDslToIndexConverter();
        FromDocumentFieldValueConverter indexToProjectionConverter = this.createIndexToProjectionConverter();
        ElasticsearchStringFieldCodec codec = ElasticsearchStringFieldCodec.INSTANCE;
        return new ElasticsearchIndexFieldType<String>(codec, new ElasticsearchTextFieldPredicateBuilderFactory(dslToIndexConverter, this.createToDocumentRawConverter(), codec, mapping), new ElasticsearchStandardFieldSortBuilderFactory<String>(resolvedSortable, dslToIndexConverter, this.createToDocumentRawConverter(), codec), new ElasticsearchStandardFieldProjectionBuilderFactory<String>(resolvedProjectable, indexToProjectionConverter, this.createFromDocumentRawConverter(), codec), mapping);
    }

    @Override
    protected ElasticsearchStringIndexFieldTypeContext thisAsS() {
        return this;
    }
}

