/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.work.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.backend.elasticsearch.client.impl.Paths;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchRequest;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchResponse;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.backend.elasticsearch.work.builder.impl.BulkWorkBuilder;
import org.hibernate.search.backend.elasticsearch.work.impl.BulkableElasticsearchWork;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchForwardingWorkExecutionContext;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchWork;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchWorkAggregator;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchWorkExecutionContext;
import org.hibernate.search.backend.elasticsearch.work.result.impl.BulkResult;
import org.hibernate.search.backend.elasticsearch.work.result.impl.BulkResultItemExtractor;
import org.hibernate.search.engine.backend.index.DocumentRefreshStrategy;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.impl.Futures;
import org.hibernate.search.util.common.impl.Throwables;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class BulkWork
implements ElasticsearchWork<BulkResult> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final JsonAccessor<JsonArray> BULK_ITEMS = JsonAccessor.root().property("items").asArray();
    private final ElasticsearchRequest request;
    private final List<BulkableElasticsearchWork<?>> works;
    private final DocumentRefreshStrategy refreshStrategy;

    protected BulkWork(Builder builder) {
        this.request = builder.buildRequest();
        this.works = new ArrayList(builder.bulkableWorks);
        this.refreshStrategy = builder.refreshStrategy;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "works = " + this.works + ", refreshStrategy = " + this.refreshStrategy + "]";
    }

    @Override
    public CompletableFuture<BulkResult> execute(ElasticsearchWorkExecutionContext context) {
        return ((CompletableFuture)Futures.create(() -> context.getClient().submit(this.request)).thenApply(this::generateResult)).exceptionally(Futures.handler(throwable -> {
            throw log.elasticsearchRequestFailed(this.request, null, Throwables.expectException((Throwable)throwable));
        }));
    }

    @Override
    public CompletableFuture<BulkResult> aggregate(ElasticsearchWorkAggregator aggregator) {
        return aggregator.addNonBulkable(this);
    }

    @Override
    public Object getInfo() {
        return null;
    }

    private BulkResult generateResult(ElasticsearchResponse response) {
        JsonObject parsedResponseBody = response.getBody();
        JsonArray resultItems = BULK_ITEMS.get(parsedResponseBody).orElseGet(JsonArray::new);
        return new BulkResultImpl(resultItems, this.refreshStrategy);
    }

    private static class BulkResultItemExtractorImpl
    implements BulkResultItemExtractor {
        private final JsonArray results;
        private final ElasticsearchWorkExecutionContext context;

        public BulkResultItemExtractorImpl(JsonArray results, ElasticsearchWorkExecutionContext context) {
            this.results = results;
            this.context = context;
        }

        @Override
        public <T> CompletableFuture<T> extract(BulkableElasticsearchWork<T> work, int index) {
            JsonObject bulkItemResponse = this.results.get(index).getAsJsonObject();
            return work.handleBulkResult(this.context, bulkItemResponse);
        }
    }

    private static class BulkResultImpl
    implements BulkResult {
        private final JsonArray results;
        private final DocumentRefreshStrategy refreshStrategy;

        public BulkResultImpl(JsonArray results, DocumentRefreshStrategy refreshStrategy) {
            this.results = results;
            this.refreshStrategy = refreshStrategy;
        }

        @Override
        public BulkResultItemExtractor withContext(ElasticsearchWorkExecutionContext context) {
            ElasticsearchWorkExecutionContext actualContext;
            switch (this.refreshStrategy) {
                case FORCE: {
                    actualContext = new NoIndexDirtyBulkExecutionContext(context);
                    break;
                }
                case NONE: {
                    actualContext = context;
                    break;
                }
                default: {
                    throw new AssertionFailure("Unexpected refresh strategy: " + this.refreshStrategy);
                }
            }
            return new BulkResultItemExtractorImpl(this.results, actualContext);
        }
    }

    public static class Builder
    implements BulkWorkBuilder {
        private final List<? extends BulkableElasticsearchWork<?>> bulkableWorks;
        private DocumentRefreshStrategy refreshStrategy = DocumentRefreshStrategy.NONE;

        public Builder(List<? extends BulkableElasticsearchWork<?>> bulkableWorks) {
            this.bulkableWorks = bulkableWorks;
        }

        @Override
        public Builder refresh(DocumentRefreshStrategy refreshStrategy) {
            this.refreshStrategy = refreshStrategy;
            return this;
        }

        protected ElasticsearchRequest buildRequest() {
            ElasticsearchRequest.Builder builder = ElasticsearchRequest.post().pathComponent(Paths._BULK);
            switch (this.refreshStrategy) {
                case FORCE: {
                    builder.param("refresh", true);
                    break;
                }
            }
            for (BulkableElasticsearchWork<?> work : this.bulkableWorks) {
                builder.body(work.getBulkableActionMetadata());
                JsonObject actionBody = work.getBulkableActionBody();
                if (actionBody == null) continue;
                builder.body(actionBody);
            }
            return builder.build();
        }

        @Override
        public BulkWork build() {
            return new BulkWork(this);
        }
    }

    private static class NoIndexDirtyBulkExecutionContext
    extends ElasticsearchForwardingWorkExecutionContext {
        public NoIndexDirtyBulkExecutionContext(ElasticsearchWorkExecutionContext delegate) {
            super(delegate);
        }

        @Override
        public void registerIndexToRefresh(URLEncodedString indexName) {
        }
    }
}

