/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.document.model.dsl.impl;

import java.lang.invoke.MethodHandles;
import java.util.LinkedHashMap;
import java.util.Map;
import org.hibernate.search.backend.elasticsearch.document.model.dsl.impl.ElasticsearchIndexSchemaFieldNodeBuilder;
import org.hibernate.search.backend.elasticsearch.document.model.dsl.impl.ElasticsearchIndexSchemaObjectFieldNodeBuilder;
import org.hibernate.search.backend.elasticsearch.document.model.dsl.impl.ElasticsearchIndexSchemaRootNodeBuilder;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaNodeCollector;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaNodeContributor;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaObjectNode;
import org.hibernate.search.backend.elasticsearch.document.model.impl.esnative.AbstractTypeMapping;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.types.impl.ElasticsearchIndexFieldType;
import org.hibernate.search.engine.backend.document.IndexFieldReference;
import org.hibernate.search.engine.backend.document.model.dsl.IndexSchemaFieldContext;
import org.hibernate.search.engine.backend.document.model.dsl.ObjectFieldStorage;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexSchemaObjectFieldNodeBuilder;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexSchemaObjectNodeBuilder;
import org.hibernate.search.engine.backend.types.IndexFieldType;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public abstract class AbstractElasticsearchIndexSchemaObjectNodeBuilder
implements IndexSchemaObjectNodeBuilder {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final Map<String, ElasticsearchIndexSchemaNodeContributor> content = new LinkedHashMap<String, ElasticsearchIndexSchemaNodeContributor>();

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "absolutePath=" + this.getAbsolutePath() + "]";
    }

    public <F> IndexSchemaFieldContext<?, IndexFieldReference<F>> addField(String relativeFieldName, IndexFieldType<F> indexFieldType) {
        ElasticsearchIndexFieldType elasticsearchIndexFieldType = (ElasticsearchIndexFieldType)indexFieldType;
        ElasticsearchIndexSchemaFieldNodeBuilder childBuilder = new ElasticsearchIndexSchemaFieldNodeBuilder(this, relativeFieldName, elasticsearchIndexFieldType);
        this.putField(relativeFieldName, childBuilder);
        return childBuilder;
    }

    public <F> IndexSchemaFieldContext<?, IndexFieldReference<F>> createExcludedField(String relativeFieldName, IndexFieldType<F> indexFieldType) {
        ElasticsearchIndexFieldType elasticsearchIndexFieldType = (ElasticsearchIndexFieldType)indexFieldType;
        return new ElasticsearchIndexSchemaFieldNodeBuilder(this, relativeFieldName, elasticsearchIndexFieldType);
    }

    public IndexSchemaObjectFieldNodeBuilder addObjectField(String relativeFieldName, ObjectFieldStorage storage) {
        ElasticsearchIndexSchemaObjectFieldNodeBuilder objectFieldBuilder = new ElasticsearchIndexSchemaObjectFieldNodeBuilder(this, relativeFieldName, storage);
        this.putField(relativeFieldName, objectFieldBuilder);
        return objectFieldBuilder;
    }

    public IndexSchemaObjectFieldNodeBuilder createExcludedObjectField(String relativeFieldName, ObjectFieldStorage storage) {
        return new ElasticsearchIndexSchemaObjectFieldNodeBuilder(this, relativeFieldName, storage);
    }

    final void contributeChildren(AbstractTypeMapping mapping, ElasticsearchIndexSchemaObjectNode node, ElasticsearchIndexSchemaNodeCollector collector) {
        for (Map.Entry<String, ElasticsearchIndexSchemaNodeContributor> entry : this.content.entrySet()) {
            ElasticsearchIndexSchemaNodeContributor propertyContributor = entry.getValue();
            propertyContributor.contribute(collector, node, mapping);
        }
    }

    abstract ElasticsearchIndexSchemaRootNodeBuilder getRootNodeBuilder();

    abstract String getAbsolutePath();

    private void putField(String name, ElasticsearchIndexSchemaNodeContributor contributor) {
        ElasticsearchIndexSchemaNodeContributor previous = this.content.putIfAbsent(name, contributor);
        if (previous != null) {
            throw log.indexSchemaNodeNameConflict(name, this.getEventContext());
        }
    }
}

