/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.gson.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.function.Supplier;
import org.hibernate.search.backend.elasticsearch.gson.spi.GsonProvider;
import org.hibernate.search.backend.elasticsearch.gson.spi.JsonLogHelper;

public class DefaultGsonProvider
implements GsonProvider {
    private final Gson gson;
    private final Gson gsonNoSerializeNulls;
    private final JsonLogHelper logHelper;

    public static GsonProvider create(Supplier<GsonBuilder> builderBaseSupplier, boolean logPrettyPrinting) {
        return new DefaultGsonProvider(builderBaseSupplier, logPrettyPrinting);
    }

    private DefaultGsonProvider(Supplier<GsonBuilder> builderBaseSupplier, boolean logPrettyPrinting) {
        this.gson = builderBaseSupplier.get().serializeNulls().create();
        this.gsonNoSerializeNulls = builderBaseSupplier.get().create();
        this.logHelper = JsonLogHelper.create(builderBaseSupplier.get(), logPrettyPrinting);
    }

    @Override
    public Gson getGson() {
        return this.gson;
    }

    @Override
    public Gson getGsonNoSerializeNulls() {
        return this.gsonNoSerializeNulls;
    }

    @Override
    public JsonLogHelper getLogHelper() {
        return this.logHelper;
    }
}

