/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.index.impl;

import java.lang.invoke.MethodHandles;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.search.backend.elasticsearch.index.impl.ElasticsearchIndexManagerImpl;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.scope.impl.ElasticsearchIndexScope;
import org.hibernate.search.backend.elasticsearch.scope.model.impl.ElasticsearchScopeModel;
import org.hibernate.search.backend.elasticsearch.search.query.impl.SearchBackendContext;
import org.hibernate.search.engine.backend.scope.spi.IndexScope;
import org.hibernate.search.engine.backend.scope.spi.IndexScopeBuilder;
import org.hibernate.search.engine.mapper.mapping.context.spi.MappingContextImplementor;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class ElasticsearchIndexScopeBuilder
implements IndexScopeBuilder {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final SearchBackendContext searchBackendContext;
    private final MappingContextImplementor mappingContext;
    private final Set<ElasticsearchIndexManagerImpl> indexManagers = new LinkedHashSet<ElasticsearchIndexManagerImpl>();

    ElasticsearchIndexScopeBuilder(SearchBackendContext searchBackendContext, MappingContextImplementor mappingContext, ElasticsearchIndexManagerImpl indexManager) {
        this.searchBackendContext = searchBackendContext;
        this.mappingContext = mappingContext;
        this.indexManagers.add(indexManager);
    }

    void add(SearchBackendContext searchBackendContext, ElasticsearchIndexManagerImpl indexManager) {
        if (!this.searchBackendContext.equals(searchBackendContext)) {
            throw log.cannotMixElasticsearchScopeWithOtherBackend(this, indexManager, searchBackendContext.getEventContext());
        }
        this.indexManagers.add(indexManager);
    }

    public IndexScope<?> build() {
        Set indexModels = this.indexManagers.stream().map(ElasticsearchIndexManagerImpl::getModel).collect(Collectors.toCollection(LinkedHashSet::new));
        ElasticsearchScopeModel model = new ElasticsearchScopeModel(indexModels);
        return new ElasticsearchIndexScope(this.mappingContext, this.searchBackendContext, model);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "searchBackendContext=" + this.searchBackendContext + ", indexManagers=" + this.indexManagers + "]";
    }
}

