/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.predicate.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.invoke.MethodHandles;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonObjectAccessor;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.scope.model.impl.ElasticsearchCompatibilityChecker;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchContext;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.AbstractElasticsearchSearchPredicateBuilder;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicateBuilder;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicateContext;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchFieldCodec;
import org.hibernate.search.engine.backend.types.converter.ToDocumentFieldValueConverter;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.engine.search.predicate.DslConverter;
import org.hibernate.search.engine.search.predicate.spi.RangePredicateBuilder;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class ElasticsearchRangePredicateBuilder<F>
extends AbstractElasticsearchSearchPredicateBuilder
implements RangePredicateBuilder<ElasticsearchSearchPredicateBuilder> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final JsonObjectAccessor RANGE_ACCESSOR = JsonAccessor.root().property("range").asObject();
    private static final JsonAccessor<JsonElement> GT_ACCESSOR = JsonAccessor.root().property("gt");
    private static final JsonAccessor<JsonElement> GTE_ACCESSOR = JsonAccessor.root().property("gte");
    private static final JsonAccessor<JsonElement> LT_ACCESSOR = JsonAccessor.root().property("lt");
    private static final JsonAccessor<JsonElement> LTE_ACCESSOR = JsonAccessor.root().property("lte");
    private final ElasticsearchSearchContext searchContext;
    private final String absoluteFieldPath;
    private final ToDocumentFieldValueConverter<?, ? extends F> converter;
    private final ToDocumentFieldValueConverter<F, ? extends F> rawConverter;
    private final ElasticsearchCompatibilityChecker converterChecker;
    private final ElasticsearchFieldCodec<F> codec;
    private JsonElement lowerLimit;
    private boolean excludeLowerLimit = false;
    private JsonElement upperLimit;
    private boolean excludeUpperLimit = false;

    public ElasticsearchRangePredicateBuilder(ElasticsearchSearchContext searchContext, String absoluteFieldPath, ToDocumentFieldValueConverter<?, ? extends F> converter, ToDocumentFieldValueConverter<F, ? extends F> rawConverter, ElasticsearchCompatibilityChecker converterChecker, ElasticsearchFieldCodec<F> codec) {
        this.searchContext = searchContext;
        this.absoluteFieldPath = absoluteFieldPath;
        this.converter = converter;
        this.rawConverter = rawConverter;
        this.converterChecker = converterChecker;
        this.codec = codec;
    }

    public void lowerLimit(Object value, DslConverter dslConverter) {
        ToDocumentFieldValueConverter<?, F> dslToIndexConverter = this.getDslToIndexConverter(dslConverter);
        try {
            Object converted = dslToIndexConverter.convertUnknown(value, this.searchContext.getToDocumentFieldValueConvertContext());
            this.lowerLimit = this.codec.encode(converted);
        }
        catch (RuntimeException e) {
            throw log.cannotConvertDslParameter(e.getMessage(), e, EventContexts.fromIndexFieldAbsolutePath((String)this.absoluteFieldPath));
        }
    }

    public void excludeLowerLimit() {
        this.excludeLowerLimit = true;
    }

    public void upperLimit(Object value, DslConverter dslConverter) {
        ToDocumentFieldValueConverter<?, F> dslToIndexConverter = this.getDslToIndexConverter(dslConverter);
        try {
            Object converted = dslToIndexConverter.convertUnknown(value, this.searchContext.getToDocumentFieldValueConvertContext());
            this.upperLimit = this.codec.encode(converted);
        }
        catch (RuntimeException e) {
            throw log.cannotConvertDslParameter(e.getMessage(), e, EventContexts.fromIndexFieldAbsolutePath((String)this.absoluteFieldPath));
        }
    }

    public void excludeUpperLimit() {
        this.excludeUpperLimit = true;
    }

    @Override
    protected JsonObject doBuild(ElasticsearchSearchPredicateContext context, JsonObject outerObject, JsonObject innerObject) {
        JsonAccessor<JsonElement> accessor;
        if (this.lowerLimit != null) {
            accessor = this.excludeLowerLimit ? GT_ACCESSOR : GTE_ACCESSOR;
            accessor.set(innerObject, this.lowerLimit);
        }
        if (this.upperLimit != null) {
            accessor = this.excludeUpperLimit ? LT_ACCESSOR : LTE_ACCESSOR;
            accessor.set(innerObject, this.upperLimit);
        }
        JsonObject middleObject = new JsonObject();
        middleObject.add(this.absoluteFieldPath, (JsonElement)innerObject);
        RANGE_ACCESSOR.set(outerObject, middleObject);
        return outerObject;
    }

    private ToDocumentFieldValueConverter<?, ? extends F> getDslToIndexConverter(DslConverter dslConverter) {
        if (dslConverter.isEnabled()) {
            this.converterChecker.failIfNotCompatible();
        }
        return dslConverter.isEnabled() ? this.converter : this.rawConverter;
    }
}

