/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.projection.impl;

import com.google.gson.JsonObject;
import java.util.Set;
import java.util.function.Function;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchCompositeProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchSearchProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.SearchProjectionExtractContext;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.SearchProjectionTransformContext;
import org.hibernate.search.engine.search.loading.spi.LoadingResult;
import org.hibernate.search.engine.search.loading.spi.ProjectionHitMapper;

public class ElasticsearchCompositeFunctionProjection<E, P1, P>
implements ElasticsearchCompositeProjection<E, P> {
    private final Set<String> indexNames;
    private final Function<P1, P> transformer;
    private final ElasticsearchSearchProjection<E, P1> projection;

    public ElasticsearchCompositeFunctionProjection(Set<String> indexNames, Function<P1, P> transformer, ElasticsearchSearchProjection<E, P1> projection) {
        this.indexNames = indexNames;
        this.transformer = transformer;
        this.projection = projection;
    }

    @Override
    public void contributeRequest(JsonObject requestBody, SearchProjectionExtractContext context) {
        this.projection.contributeRequest(requestBody, context);
    }

    @Override
    public E extract(ProjectionHitMapper<?, ?> projectionHitMapper, JsonObject responseBody, JsonObject hit, SearchProjectionExtractContext context) {
        return this.projection.extract(projectionHitMapper, responseBody, hit, context);
    }

    @Override
    public P transform(LoadingResult<?> loadingResult, E extractedData, SearchProjectionTransformContext context) {
        return this.transformer.apply(this.projection.transform(loadingResult, extractedData, context));
    }

    @Override
    public Set<String> getIndexNames() {
        return this.indexNames;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("[").append("projection=").append(this.projection).append("]");
        return sb.toString();
    }
}

