/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.projection.impl;

import com.google.gson.Gson;
import java.util.Set;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.DocumentReferenceExtractorHelper;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchDocumentReferenceProjectionBuilder;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchEntityProjectionBuilder;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchEntityReferenceProjectionBuilder;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchExplanationProjectionBuilder;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchScoreProjectionBuilder;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchSourceProjectionBuilder;
import org.hibernate.search.engine.search.projection.spi.SearchProjectionBuilder;

public class SearchProjectionBackendContext {
    private final DocumentReferenceExtractorHelper documentReferenceExtractorHelper;
    private final Gson userFacingGson;

    public SearchProjectionBackendContext(DocumentReferenceExtractorHelper documentReferenceExtractorHelper, Gson userFacingGson) {
        this.documentReferenceExtractorHelper = documentReferenceExtractorHelper;
        this.userFacingGson = userFacingGson;
    }

    ElasticsearchDocumentReferenceProjectionBuilder createDocumentReferenceProjectionBuilder(Set<String> indexNames) {
        return new ElasticsearchDocumentReferenceProjectionBuilder(indexNames, this.documentReferenceExtractorHelper);
    }

    <E> ElasticsearchEntityProjectionBuilder<E> createEntityProjectionBuilder(Set<String> indexNames) {
        return new ElasticsearchEntityProjectionBuilder(indexNames, this.documentReferenceExtractorHelper);
    }

    <R> ElasticsearchEntityReferenceProjectionBuilder<R> createReferenceProjectionBuilder(Set<String> indexNames) {
        return new ElasticsearchEntityReferenceProjectionBuilder(indexNames, this.documentReferenceExtractorHelper);
    }

    ElasticsearchScoreProjectionBuilder createScoreProjectionBuilder(Set<String> indexNames) {
        return new ElasticsearchScoreProjectionBuilder(indexNames);
    }

    ElasticsearchSourceProjectionBuilder createSourceProjectionBuilder(Set<String> indexNames) {
        return new ElasticsearchSourceProjectionBuilder(indexNames, this.userFacingGson);
    }

    public SearchProjectionBuilder<String> createExplanationProjectionBuilder(Set<String> indexNames) {
        return new ElasticsearchExplanationProjectionBuilder(indexNames, this.userFacingGson);
    }
}

