/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.query.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.invoke.MethodHandles;
import java.util.Optional;
import java.util.Set;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.impl.ElasticsearchIndexNameNormalizer;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchWorkOrchestrator;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchContext;
import org.hibernate.search.backend.elasticsearch.search.query.ElasticsearchSearchQuery;
import org.hibernate.search.backend.elasticsearch.search.query.ElasticsearchSearchResult;
import org.hibernate.search.backend.elasticsearch.search.query.impl.ElasticsearchLoadableSearchResult;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.backend.elasticsearch.work.builder.factory.impl.ElasticsearchWorkBuilderFactory;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchSearchResultExtractor;
import org.hibernate.search.backend.elasticsearch.work.result.impl.ExplainResult;
import org.hibernate.search.engine.common.dsl.spi.DslExtensionState;
import org.hibernate.search.engine.mapper.session.context.spi.SessionContextImplementor;
import org.hibernate.search.engine.search.loading.context.spi.LoadingContext;
import org.hibernate.search.engine.search.query.SearchQuery;
import org.hibernate.search.engine.search.query.SearchQueryExtension;
import org.hibernate.search.engine.search.query.spi.AbstractSearchQuery;
import org.hibernate.search.util.common.impl.Contracts;
import org.hibernate.search.util.common.impl.Futures;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class ElasticsearchSearchQueryImpl<H>
extends AbstractSearchQuery<H, ElasticsearchSearchResult<H>>
implements ElasticsearchSearchQuery<H> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final int MAX_RESULT_WINDOW_SIZE = 10000;
    private final ElasticsearchWorkBuilderFactory workFactory;
    private final ElasticsearchWorkOrchestrator queryOrchestrator;
    private final ElasticsearchSearchContext searchContext;
    private final SessionContextImplementor sessionContext;
    private final LoadingContext<?, ?> loadingContext;
    private final Set<String> routingKeys;
    private final JsonObject payload;
    private final ElasticsearchSearchResultExtractor<H> searchResultExtractor;

    ElasticsearchSearchQueryImpl(ElasticsearchWorkBuilderFactory workFactory, ElasticsearchWorkOrchestrator queryOrchestrator, ElasticsearchSearchContext searchContext, SessionContextImplementor sessionContext, LoadingContext<?, ?> loadingContext, Set<String> routingKeys, JsonObject payload, ElasticsearchSearchResultExtractor<H> searchResultExtractor) {
        this.workFactory = workFactory;
        this.queryOrchestrator = queryOrchestrator;
        this.searchContext = searchContext;
        this.sessionContext = sessionContext;
        this.loadingContext = loadingContext;
        this.routingKeys = routingKeys;
        this.payload = payload;
        this.searchResultExtractor = searchResultExtractor;
    }

    public String getQueryString() {
        return this.payload.toString();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getQueryString() + "]";
    }

    public <Q> Q extension(SearchQueryExtension<Q, H> extension) {
        return (Q)DslExtensionState.returnIfSupported(extension, (Optional)extension.extendOptional((SearchQuery)this, this.loadingContext));
    }

    public ElasticsearchSearchResult<H> fetch(Integer limit, Integer offset) {
        Object work = this.workFactory.search(this.payload, this.searchResultExtractor).indexes(this.searchContext.getIndexNames()).paging(this.defaultedLimit(limit, offset), offset).routingKeys(this.routingKeys).build();
        return ((ElasticsearchLoadableSearchResult)Futures.unwrappedExceptionJoin(this.queryOrchestrator.submit(work))).loadBlocking(this.sessionContext);
    }

    public long fetchTotalHitCount() {
        JsonObject filteredPayload = new JsonObject();
        Optional querySubTree = JsonAccessor.root().property("query").asObject().get(this.payload);
        if (querySubTree.isPresent()) {
            filteredPayload.add("query", (JsonElement)querySubTree.get());
        }
        Object work = this.workFactory.count(this.searchContext.getIndexNames()).query(filteredPayload).routingKeys(this.routingKeys).build();
        return (Long)this.queryOrchestrator.submit(work).join();
    }

    @Override
    public String explain(String id) {
        Contracts.assertNotNull((Object)id, (String)"id");
        Set<URLEncodedString> targetedIndexNames = this.searchContext.getIndexNames();
        if (targetedIndexNames.size() != 1) {
            throw log.explainRequiresIndexName(targetedIndexNames);
        }
        return this.doExplain(targetedIndexNames.iterator().next(), id);
    }

    @Override
    public String explain(String indexName, String id) {
        Contracts.assertNotNull((Object)indexName, (String)"indexName");
        Contracts.assertNotNull((Object)id, (String)"id");
        Set<URLEncodedString> targetedIndexNames = this.searchContext.getIndexNames();
        URLEncodedString encodedIndexName = URLEncodedString.fromString(ElasticsearchIndexNameNormalizer.normalize(indexName));
        if (!targetedIndexNames.contains(encodedIndexName)) {
            throw log.explainRequiresIndexTargetedByQuery(targetedIndexNames, encodedIndexName);
        }
        return this.doExplain(encodedIndexName, id);
    }

    private Integer defaultedLimit(Integer limit, Integer offset) {
        if (limit != null) {
            return limit;
        }
        int maxLimitThatElasticsearchWillAccept = 10000;
        if (offset != null) {
            maxLimitThatElasticsearchWillAccept -= offset.intValue();
        }
        return maxLimitThatElasticsearchWillAccept;
    }

    private String doExplain(URLEncodedString encodedIndexName, String id) {
        URLEncodedString elasticsearchId = URLEncodedString.fromString(this.searchContext.toElasticsearchId(this.sessionContext.getTenantIdentifier(), id));
        Object work = this.workFactory.explain(encodedIndexName, elasticsearchId, this.payload).routingKeys(this.routingKeys).build();
        ExplainResult explainResult = (ExplainResult)Futures.unwrappedExceptionJoin(this.queryOrchestrator.submit(work));
        return this.searchContext.getUserFacingGson().toJson((JsonElement)explainResult.getJsonObject());
    }
}

