/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.sort.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.lang.invoke.MethodHandles;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.scope.model.impl.ElasticsearchCompatibilityChecker;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchContext;
import org.hibernate.search.backend.elasticsearch.search.sort.impl.AbstractElasticsearchSearchSortBuilder;
import org.hibernate.search.backend.elasticsearch.search.sort.impl.ElasticsearchSearchSortBuilder;
import org.hibernate.search.backend.elasticsearch.search.sort.impl.ElasticsearchSearchSortCollector;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchFieldCodec;
import org.hibernate.search.engine.backend.types.converter.ToDocumentFieldValueConverter;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.engine.search.predicate.DslConverter;
import org.hibernate.search.engine.search.sort.spi.FieldSortBuilder;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class ElasticsearchFieldSortBuilder<F>
extends AbstractElasticsearchSearchSortBuilder
implements FieldSortBuilder<ElasticsearchSearchSortBuilder> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final JsonAccessor<JsonElement> MISSING_ACCESSOR = JsonAccessor.root().property("missing");
    private static final JsonPrimitive MISSING_FIRST_KEYWORD_JSON = new JsonPrimitive("_first");
    private static final JsonPrimitive MISSING_LAST_KEYWORD_JSON = new JsonPrimitive("_last");
    private final ElasticsearchSearchContext searchContext;
    private final String absoluteFieldPath;
    private final ToDocumentFieldValueConverter<?, ? extends F> converter;
    private final ToDocumentFieldValueConverter<F, ? extends F> rawConverter;
    private final ElasticsearchCompatibilityChecker converterChecker;
    private final ElasticsearchFieldCodec<F> codec;
    private JsonElement missing;

    public ElasticsearchFieldSortBuilder(ElasticsearchSearchContext searchContext, String absoluteFieldPath, ToDocumentFieldValueConverter<?, ? extends F> converter, ToDocumentFieldValueConverter<F, ? extends F> rawConverter, ElasticsearchCompatibilityChecker converterChecker, ElasticsearchFieldCodec<F> codec) {
        this.searchContext = searchContext;
        this.absoluteFieldPath = absoluteFieldPath;
        this.converter = converter;
        this.rawConverter = rawConverter;
        this.converterChecker = converterChecker;
        this.codec = codec;
    }

    public void missingFirst() {
        this.missing = MISSING_FIRST_KEYWORD_JSON;
    }

    public void missingLast() {
        this.missing = MISSING_LAST_KEYWORD_JSON;
    }

    public void missingAs(Object value, DslConverter dslConverter) {
        if (dslConverter.isEnabled()) {
            this.converterChecker.failIfNotCompatible();
        }
        Object dslToIndexConverter = dslConverter.isEnabled() ? this.converter : this.rawConverter;
        try {
            Object converted = dslToIndexConverter.convertUnknown(value, this.searchContext.getToDocumentFieldValueConvertContext());
            this.missing = this.codec.encodeForMissing(converted);
        }
        catch (RuntimeException e) {
            throw log.cannotConvertDslParameter(e.getMessage(), e, EventContexts.fromIndexFieldAbsolutePath((String)this.absoluteFieldPath));
        }
    }

    @Override
    public void doBuildAndAddTo(ElasticsearchSearchSortCollector collector, JsonObject innerObject) {
        if (this.missing != null) {
            MISSING_ACCESSOR.set(innerObject, this.missing);
        }
        if (innerObject.size() == 0) {
            collector.collectSort((JsonElement)new JsonPrimitive(this.absoluteFieldPath));
        } else {
            JsonObject outerObject = new JsonObject();
            outerObject.add(this.absoluteFieldPath, (JsonElement)innerObject);
            collector.collectSort((JsonElement)outerObject);
        }
    }
}

