/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.codec.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonPrimitive;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonElementTypes;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchFieldCodec;

public abstract class AbstractElasticsearchJavaTimeFieldCodec<T extends TemporalAccessor>
implements ElasticsearchFieldCodec<T> {
    protected final DateTimeFormatter formatter;

    public AbstractElasticsearchJavaTimeFieldCodec(DateTimeFormatter delegate) {
        this.formatter = delegate;
    }

    @Override
    public JsonElement encode(T value) {
        if (value == null) {
            return JsonNull.INSTANCE;
        }
        return new JsonPrimitive(this.nullUnsafeFormat(value));
    }

    @Override
    public JsonElement encodeForMissing(T value) {
        if (value == null) {
            return null;
        }
        return new JsonPrimitive((Number)this.nullUnsafeScalar(value));
    }

    @Override
    public T decode(JsonElement element) {
        if (element == null || element.isJsonNull()) {
            return null;
        }
        return this.nullUnsafeParse(JsonElementTypes.STRING.fromElement(element));
    }

    @Override
    public boolean isCompatibleWith(ElasticsearchFieldCodec<?> obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        AbstractElasticsearchJavaTimeFieldCodec other = (AbstractElasticsearchJavaTimeFieldCodec)obj;
        return this.formatter.equals(other.formatter);
    }

    protected String nullUnsafeFormat(T value) {
        return this.formatter.format((TemporalAccessor)value);
    }

    protected abstract T nullUnsafeParse(String var1);

    protected abstract Long nullUnsafeScalar(T var1);
}

