/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.codec.impl;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchFieldCodec;

public class ElasticsearchJsonStringFieldCodec
implements ElasticsearchFieldCodec<String> {
    private final Gson gson;

    public ElasticsearchJsonStringFieldCodec(Gson gson) {
        this.gson = gson;
    }

    @Override
    public JsonElement encode(String value) {
        if (value == null) {
            return JsonNull.INSTANCE;
        }
        return (JsonElement)this.gson.fromJson(value, JsonElement.class);
    }

    @Override
    public String decode(JsonElement element) {
        if (element == null || element.isJsonNull()) {
            return null;
        }
        return this.gson.toJson(element);
    }

    @Override
    public boolean isCompatibleWith(ElasticsearchFieldCodec<?> other) {
        if (other == this) {
            return true;
        }
        if (other == null || !this.getClass().equals(other.getClass())) {
            return false;
        }
        ElasticsearchJsonStringFieldCodec castedOther = (ElasticsearchJsonStringFieldCodec)other;
        return this.gson.equals(castedOther.gson);
    }
}

