/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.dsl.impl;

import org.hibernate.search.backend.elasticsearch.document.model.impl.esnative.DataType;
import org.hibernate.search.backend.elasticsearch.document.model.impl.esnative.PropertyMapping;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.AbstractElasticsearchStandardIndexFieldTypeContext;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchIndexFieldTypeBuildContext;
import org.hibernate.search.backend.elasticsearch.types.impl.ElasticsearchIndexFieldType;
import org.hibernate.search.engine.backend.types.IndexFieldType;
import org.hibernate.search.engine.backend.types.Projectable;
import org.hibernate.search.engine.backend.types.Searchable;
import org.hibernate.search.engine.backend.types.Sortable;

abstract class AbstractElasticsearchScalarFieldTypeContext<S extends AbstractElasticsearchScalarFieldTypeContext<? extends S, F>, F>
extends AbstractElasticsearchStandardIndexFieldTypeContext<S, F> {
    private final DataType dataType;
    private Sortable sortable = Sortable.DEFAULT;
    protected boolean resolvedSortable;
    private Projectable projectable = Projectable.DEFAULT;
    protected boolean resolvedProjectable;
    private Searchable searchable = Searchable.DEFAULT;
    protected boolean resolvedSearchable;
    protected F indexNullAs;

    AbstractElasticsearchScalarFieldTypeContext(ElasticsearchIndexFieldTypeBuildContext buildContext, Class<F> fieldType, DataType dataType) {
        super(buildContext, fieldType);
        this.dataType = dataType;
    }

    public S projectable(Projectable projectable) {
        this.projectable = projectable;
        return (S)((AbstractElasticsearchScalarFieldTypeContext)this.thisAsS());
    }

    public S sortable(Sortable sortable) {
        this.sortable = sortable;
        return (S)((AbstractElasticsearchScalarFieldTypeContext)this.thisAsS());
    }

    public S indexNullAs(F indexNullAs) {
        this.indexNullAs = indexNullAs;
        return (S)((AbstractElasticsearchScalarFieldTypeContext)this.thisAsS());
    }

    public S searchable(Searchable searchable) {
        this.searchable = searchable;
        return (S)((AbstractElasticsearchScalarFieldTypeContext)this.thisAsS());
    }

    public final IndexFieldType<F> toIndexFieldType() {
        PropertyMapping mapping = new PropertyMapping();
        mapping.setType(this.dataType);
        this.resolvedSortable = AbstractElasticsearchScalarFieldTypeContext.resolveDefault(this.sortable);
        this.resolvedProjectable = AbstractElasticsearchScalarFieldTypeContext.resolveDefault(this.projectable);
        this.resolvedSearchable = AbstractElasticsearchScalarFieldTypeContext.resolveDefault(this.searchable);
        mapping.setIndex(this.resolvedSearchable);
        mapping.setStore(this.resolvedProjectable);
        mapping.setDocValues(this.resolvedSortable);
        ElasticsearchIndexFieldType<F> indexFieldType = this.toIndexFieldType(mapping);
        if (this.indexNullAs != null) {
            indexFieldType.indexNullAs(this.indexNullAs);
        }
        return indexFieldType;
    }

    protected abstract ElasticsearchIndexFieldType<F> toIndexFieldType(PropertyMapping var1);
}

