/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.dsl.impl;

import com.google.gson.Gson;
import org.hibernate.search.backend.elasticsearch.document.model.impl.esnative.PropertyMapping;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchJsonStringFieldCodec;
import org.hibernate.search.backend.elasticsearch.types.dsl.ElasticsearchNativeIndexFieldTypeContext;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.AbstractElasticsearchIndexFieldTypeConverterContext;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchIndexFieldTypeBuildContext;
import org.hibernate.search.backend.elasticsearch.types.impl.ElasticsearchIndexFieldType;
import org.hibernate.search.backend.elasticsearch.types.predicate.impl.ElasticsearchStandardFieldPredicateBuilderFactory;
import org.hibernate.search.backend.elasticsearch.types.projection.impl.ElasticsearchStandardFieldProjectionBuilderFactory;
import org.hibernate.search.backend.elasticsearch.types.sort.impl.ElasticsearchStandardFieldSortBuilderFactory;
import org.hibernate.search.engine.backend.types.IndexFieldType;
import org.hibernate.search.engine.backend.types.converter.FromDocumentFieldValueConverter;
import org.hibernate.search.engine.backend.types.converter.ToDocumentFieldValueConverter;

class ElasticsearchNativeIndexFieldTypeContextImpl
extends AbstractElasticsearchIndexFieldTypeConverterContext<ElasticsearchNativeIndexFieldTypeContextImpl, String>
implements ElasticsearchNativeIndexFieldTypeContext<ElasticsearchNativeIndexFieldTypeContextImpl> {
    private final String mappingJsonString;

    ElasticsearchNativeIndexFieldTypeContextImpl(ElasticsearchIndexFieldTypeBuildContext buildContext, String mappingJsonString) {
        super(buildContext, String.class);
        this.mappingJsonString = mappingJsonString;
    }

    @Override
    protected ElasticsearchNativeIndexFieldTypeContextImpl thisAsS() {
        return this;
    }

    public IndexFieldType<String> toIndexFieldType() {
        Gson gson = this.getBuildContext().getUserFacingGson();
        PropertyMapping mapping = (PropertyMapping)gson.fromJson(this.mappingJsonString, PropertyMapping.class);
        ToDocumentFieldValueConverter dslToIndexConverter = this.createDslToIndexConverter();
        FromDocumentFieldValueConverter indexToProjectionConverter = this.createIndexToProjectionConverter();
        ElasticsearchJsonStringFieldCodec codec = new ElasticsearchJsonStringFieldCodec(gson);
        return new ElasticsearchIndexFieldType<String>(codec, new ElasticsearchStandardFieldPredicateBuilderFactory<String>(true, dslToIndexConverter, this.createToDocumentRawConverter(), codec), new ElasticsearchStandardFieldSortBuilderFactory<String>(true, dslToIndexConverter, this.createToDocumentRawConverter(), codec), new ElasticsearchStandardFieldProjectionBuilderFactory<String>(true, indexToProjectionConverter, this.createFromDocumentRawConverter(), codec), mapping);
    }
}

