/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.dsl.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.lang.invoke.MethodHandles;
import java.util.Locale;
import org.hibernate.search.backend.elasticsearch.document.model.impl.esnative.DataType;
import org.hibernate.search.backend.elasticsearch.document.model.impl.esnative.PropertyMapping;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchStringFieldCodec;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.AbstractElasticsearchStandardIndexFieldTypeContext;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchIndexFieldTypeBuildContext;
import org.hibernate.search.backend.elasticsearch.types.impl.ElasticsearchIndexFieldType;
import org.hibernate.search.backend.elasticsearch.types.predicate.impl.ElasticsearchTextFieldPredicateBuilderFactory;
import org.hibernate.search.backend.elasticsearch.types.projection.impl.ElasticsearchStandardFieldProjectionBuilderFactory;
import org.hibernate.search.backend.elasticsearch.types.sort.impl.ElasticsearchStandardFieldSortBuilderFactory;
import org.hibernate.search.engine.backend.types.IndexFieldType;
import org.hibernate.search.engine.backend.types.Norms;
import org.hibernate.search.engine.backend.types.Projectable;
import org.hibernate.search.engine.backend.types.Searchable;
import org.hibernate.search.engine.backend.types.Sortable;
import org.hibernate.search.engine.backend.types.TermVector;
import org.hibernate.search.engine.backend.types.converter.FromDocumentFieldValueConverter;
import org.hibernate.search.engine.backend.types.converter.ToDocumentFieldValueConverter;
import org.hibernate.search.engine.backend.types.dsl.StringIndexFieldTypeContext;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class ElasticsearchStringIndexFieldTypeContext
extends AbstractElasticsearchStandardIndexFieldTypeContext<ElasticsearchStringIndexFieldTypeContext, String>
implements StringIndexFieldTypeContext<ElasticsearchStringIndexFieldTypeContext> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private String analyzerName;
    private String normalizerName;
    private Projectable projectable = Projectable.DEFAULT;
    private Searchable searchable = Searchable.DEFAULT;
    private Norms norms = Norms.DEFAULT;
    private Sortable sortable = Sortable.DEFAULT;
    private String indexNullAs;
    private TermVector termVector = TermVector.DEFAULT;

    ElasticsearchStringIndexFieldTypeContext(ElasticsearchIndexFieldTypeBuildContext buildContext) {
        super(buildContext, String.class);
    }

    public ElasticsearchStringIndexFieldTypeContext analyzer(String analyzerName) {
        this.analyzerName = analyzerName;
        return this;
    }

    public ElasticsearchStringIndexFieldTypeContext normalizer(String normalizerName) {
        this.normalizerName = normalizerName;
        return this;
    }

    public ElasticsearchStringIndexFieldTypeContext projectable(Projectable projectable) {
        this.projectable = projectable;
        return this;
    }

    public ElasticsearchStringIndexFieldTypeContext norms(Norms norms) {
        this.norms = norms;
        return this;
    }

    public ElasticsearchStringIndexFieldTypeContext termVector(TermVector termVector) {
        this.termVector = termVector;
        return this;
    }

    public ElasticsearchStringIndexFieldTypeContext sortable(Sortable sortable) {
        this.sortable = sortable;
        return this;
    }

    public ElasticsearchStringIndexFieldTypeContext indexNullAs(String indexNullAs) {
        this.indexNullAs = indexNullAs;
        return this;
    }

    public ElasticsearchStringIndexFieldTypeContext searchable(Searchable searchable) {
        this.searchable = searchable;
        return this;
    }

    public IndexFieldType<String> toIndexFieldType() {
        PropertyMapping mapping = new PropertyMapping();
        boolean resolvedSortable = ElasticsearchStringIndexFieldTypeContext.resolveDefault(this.sortable);
        boolean resolvedProjectable = ElasticsearchStringIndexFieldTypeContext.resolveDefault(this.projectable);
        boolean resolvedSearchable = ElasticsearchStringIndexFieldTypeContext.resolveDefault(this.searchable);
        mapping.setIndex(resolvedSearchable);
        if (this.analyzerName != null) {
            mapping.setType(DataType.TEXT);
            mapping.setAnalyzer(this.analyzerName);
            mapping.setTermVector(this.resolveTermVector());
            if (this.normalizerName != null) {
                throw log.cannotApplyAnalyzerAndNormalizer(this.analyzerName, this.normalizerName, this.getBuildContext().getEventContext());
            }
            if (resolvedSortable) {
                throw log.cannotUseAnalyzerOnSortableField(this.analyzerName, this.getBuildContext().getEventContext());
            }
            if (this.indexNullAs != null) {
                throw log.cannotUseIndexNullAsAndAnalyzer(this.analyzerName, this.indexNullAs, this.getBuildContext().getEventContext());
            }
        } else {
            mapping.setType(DataType.KEYWORD);
            mapping.setNormalizer(this.normalizerName);
            mapping.setDocValues(resolvedSortable);
        }
        mapping.setStore(resolvedProjectable);
        mapping.setNorms(this.resolveNorms());
        if (this.indexNullAs != null) {
            mapping.setNullValue((JsonElement)new JsonPrimitive(this.indexNullAs));
        }
        ToDocumentFieldValueConverter dslToIndexConverter = this.createDslToIndexConverter();
        FromDocumentFieldValueConverter indexToProjectionConverter = this.createIndexToProjectionConverter();
        ElasticsearchStringFieldCodec codec = ElasticsearchStringFieldCodec.INSTANCE;
        return new ElasticsearchIndexFieldType<String>(codec, new ElasticsearchTextFieldPredicateBuilderFactory(resolvedSearchable, dslToIndexConverter, this.createToDocumentRawConverter(), codec, mapping), new ElasticsearchStandardFieldSortBuilderFactory<String>(resolvedSortable, dslToIndexConverter, this.createToDocumentRawConverter(), codec), new ElasticsearchStandardFieldProjectionBuilderFactory<String>(resolvedProjectable, indexToProjectionConverter, this.createFromDocumentRawConverter(), codec), mapping);
    }

    @Override
    protected ElasticsearchStringIndexFieldTypeContext thisAsS() {
        return this;
    }

    private boolean resolveNorms() {
        switch (this.norms) {
            case YES: {
                return true;
            }
            case NO: {
                return false;
            }
            case DEFAULT: {
                return this.analyzerName != null;
            }
        }
        throw new AssertionFailure("Unexpected value for Norms: " + this.norms);
    }

    private String resolveTermVector() {
        switch (this.termVector) {
            case NO: 
            case DEFAULT: {
                return "no";
            }
        }
        return this.termVector.name().toLowerCase(Locale.ROOT);
    }
}

