/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.work.impl;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchRequest;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchResponse;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchRequestSuccessAssessor;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchWork;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchWorkAggregator;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchWorkExecutionContext;
import org.hibernate.search.engine.backend.work.execution.DocumentRefreshStrategy;
import org.hibernate.search.util.common.impl.Futures;
import org.hibernate.search.util.common.impl.Throwables;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public abstract class AbstractSimpleElasticsearchWork<R>
implements ElasticsearchWork<R> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final CompletableFuture<Void> SUCCESSFUL_FUTURE = CompletableFuture.completedFuture(null);
    protected final ElasticsearchRequest request;
    protected final URLEncodedString refreshedIndexName;
    protected final ElasticsearchRequestSuccessAssessor resultAssessor;
    protected final DocumentRefreshStrategy refreshStrategy;

    protected AbstractSimpleElasticsearchWork(AbstractBuilder<?> builder) {
        this.request = builder.buildRequest();
        this.refreshedIndexName = builder.refreshedIndexName;
        this.resultAssessor = builder.resultAssessor;
        this.refreshStrategy = builder.refreshStrategy;
    }

    @Override
    public Object getInfo() {
        return this;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "path = " + this.request.getPath() + ", refreshedIndexName = " + this.refreshedIndexName + ", refreshStrategy = " + this.refreshStrategy + "]";
    }

    @Override
    public final CompletableFuture<R> execute(ElasticsearchWorkExecutionContext executionContext) {
        return ((CompletableFuture)((CompletableFuture)Futures.create(() -> this.beforeExecute(executionContext, this.request)).thenCompose(ignored -> executionContext.getClient().submit(this.request))).exceptionally(Futures.handler(throwable -> {
            throw log.elasticsearchRequestFailed(this.request, null, Throwables.expectException((Throwable)throwable));
        }))).thenCompose(response -> this.handleResult(executionContext, (ElasticsearchResponse)response));
    }

    protected CompletableFuture<?> beforeExecute(ElasticsearchWorkExecutionContext executionContext, ElasticsearchRequest request) {
        return SUCCESSFUL_FUTURE;
    }

    protected CompletableFuture<?> afterSuccess(ElasticsearchWorkExecutionContext executionContext) {
        return SUCCESSFUL_FUTURE;
    }

    protected abstract R generateResult(ElasticsearchWorkExecutionContext var1, ElasticsearchResponse var2);

    @Override
    public CompletableFuture<R> aggregate(ElasticsearchWorkAggregator aggregator) {
        return aggregator.addNonBulkable(this);
    }

    private CompletableFuture<R> handleResult(ElasticsearchWorkExecutionContext executionContext, ElasticsearchResponse response) {
        Object result;
        try {
            this.resultAssessor.checkSuccess(response);
            result = this.generateResult(executionContext, response);
            switch (this.refreshStrategy) {
                case FORCE: {
                    executionContext.registerIndexToRefresh(this.refreshedIndexName);
                    break;
                }
            }
        }
        catch (RuntimeException e) {
            throw log.elasticsearchRequestFailed(this.request, response, e);
        }
        return ((CompletableFuture)this.afterSuccess(executionContext).exceptionally(Futures.handler(throwable -> {
            throw log.elasticsearchRequestFailed(this.request, response, Throwables.expectException((Throwable)throwable));
        }))).thenApply(ignored -> result);
    }

    protected static abstract class AbstractBuilder<B> {
        protected final URLEncodedString refreshedIndexName;
        protected ElasticsearchRequestSuccessAssessor resultAssessor;
        protected DocumentRefreshStrategy refreshStrategy = DocumentRefreshStrategy.NONE;

        public AbstractBuilder(URLEncodedString refreshedIndexName, ElasticsearchRequestSuccessAssessor resultAssessor) {
            this.refreshedIndexName = refreshedIndexName;
            this.resultAssessor = resultAssessor;
        }

        public B refresh(DocumentRefreshStrategy refreshStrategy) {
            this.refreshStrategy = refreshStrategy;
            return (B)this;
        }

        protected abstract ElasticsearchRequest buildRequest();

        public abstract ElasticsearchWork<?> build();
    }
}

