/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.work.impl;

import org.hibernate.search.backend.elasticsearch.cfg.ElasticsearchIndexStatus;
import org.hibernate.search.backend.elasticsearch.client.impl.Paths;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchRequest;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchResponse;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.backend.elasticsearch.work.builder.impl.WaitForIndexStatusWorkBuilder;
import org.hibernate.search.backend.elasticsearch.work.impl.AbstractSimpleElasticsearchWork;
import org.hibernate.search.backend.elasticsearch.work.impl.DefaultElasticsearchRequestSuccessAssessor;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchWorkExecutionContext;

public class WaitForIndexStatusWork
extends AbstractSimpleElasticsearchWork<Void> {
    protected WaitForIndexStatusWork(Builder builder) {
        super(builder);
    }

    @Override
    protected Void generateResult(ElasticsearchWorkExecutionContext context, ElasticsearchResponse response) {
        return null;
    }

    public static class Builder
    extends AbstractSimpleElasticsearchWork.AbstractBuilder<Builder>
    implements WaitForIndexStatusWorkBuilder {
        private final URLEncodedString indexName;
        private final ElasticsearchIndexStatus requiredStatus;
        private final String timeout;

        public Builder(URLEncodedString indexName, ElasticsearchIndexStatus requiredStatus, String timeout) {
            super(null, DefaultElasticsearchRequestSuccessAssessor.INSTANCE);
            this.indexName = indexName;
            this.requiredStatus = requiredStatus;
            this.timeout = timeout;
        }

        @Override
        protected ElasticsearchRequest buildRequest() {
            ElasticsearchRequest.Builder builder = ElasticsearchRequest.get().pathComponent(Paths._CLUSTER).pathComponent(Paths.HEALTH).pathComponent(this.indexName).param("wait_for_status", this.requiredStatus.getElasticsearchString()).param("timeout", this.timeout);
            return builder.build();
        }

        @Override
        public WaitForIndexStatusWork build() {
            return new WaitForIndexStatusWork(this);
        }
    }
}

