/*
 * Hibernate Search, full-text search for your domain model
 *
 * License: GNU Lesser General Public License (LGPL), version 2.1 or later
 * See the lgpl.txt file in the root directory or <http://www.gnu.org/licenses/lgpl-2.1.html>.
 */
package org.hibernate.search.backend.elasticsearch.analysis.model.dsl;

import org.hibernate.search.backend.elasticsearch.analysis.ElasticsearchAnalysisConfigurationContext;

/**
 * A context allowing the definition of named analysis-related elements in an Elasticsearch backend:
 * analyzers, tokenizers, char filters, ...
 *
 * @deprecated Use {@link ElasticsearchAnalysisConfigurationContext} instead.
 */
@Deprecated
public interface ElasticsearchAnalysisDefinitionContainerContext {

	/**
	 * Start an analyzer definition.
	 * @param name The name used to reference this analyzer (both in Elasticsearch and in Hibernate Search).
	 * @return The initial step of a DSL where the analyzer can be defined.
	 */
	ElasticsearchAnalyzerTypeStep analyzer(String name);

	/**
	 * Start a normalizer definition.
	 * @param name The name used to reference this normalizer (both in Elasticsearch and in Hibernate Search).
	 * @return The initial step of a DSL where the normalizer can be defined.
	 */
	ElasticsearchNormalizerTypeStep normalizer(String name);

	/**
	 * Start a tokenizer definition.
	 * @param name The name used to reference this tokenizer
	 * {@link ElasticsearchAnalyzerTokenizerStep#withTokenizer(String) in analyzer definitions}.
	 * @return The initial step of a DSL where the tokenizer can be defined.
	 */
	ElasticsearchAnalysisComponentTypeStep tokenizer(String name);

	/**
	 * Start a char filter definition.
	 * @param name The name used to reference this char filter
	 * {@link ElasticsearchAnalysisOptionalComponentsStep#withCharFilters(String...) in analyzer or normalizer definitions}.
	 * @return The initial step of a DSL where the char filter can be defined.
	 */
	ElasticsearchAnalysisComponentTypeStep charFilter(String name);

	/**
	 * Start a token filter definition.
	 * @param name The name used to reference this token filter
	 * {@link ElasticsearchAnalysisOptionalComponentsStep#withTokenFilters(String...) in analyzer or normalizer definitions}.
	 * @return The initial step of a DSL where the token filter can be defined.
	 */
	ElasticsearchAnalysisComponentTypeStep tokenFilter(String name);

}
