/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch;

import java.lang.invoke.MethodHandles;
import java.util.Optional;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.scope.impl.ElasticsearchIndexScope;
import org.hibernate.search.backend.elasticsearch.search.dsl.predicate.ElasticsearchSearchPredicateFactory;
import org.hibernate.search.backend.elasticsearch.search.dsl.predicate.impl.ElasticsearchSearchPredicateFactoryImpl;
import org.hibernate.search.backend.elasticsearch.search.dsl.projection.ElasticsearchSearchProjectionFactory;
import org.hibernate.search.backend.elasticsearch.search.dsl.projection.impl.ElasticsearchSearchProjectionFactoryImpl;
import org.hibernate.search.backend.elasticsearch.search.dsl.query.ElasticsearchSearchQueryHitTypeStep;
import org.hibernate.search.backend.elasticsearch.search.dsl.query.impl.ElasticsearchSearchQueryHitTypeStepImpl;
import org.hibernate.search.backend.elasticsearch.search.dsl.sort.ElasticsearchSearchSortFactory;
import org.hibernate.search.backend.elasticsearch.search.dsl.sort.impl.ElasticsearchSearchSortFactoryImpl;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicateBuilderFactory;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchSearchProjectionBuilderFactory;
import org.hibernate.search.backend.elasticsearch.search.query.ElasticsearchSearchQuery;
import org.hibernate.search.backend.elasticsearch.search.sort.impl.ElasticsearchSearchSortBuilderFactory;
import org.hibernate.search.backend.elasticsearch.types.dsl.ElasticsearchIndexFieldTypeFactory;
import org.hibernate.search.engine.backend.scope.spi.IndexScope;
import org.hibernate.search.engine.backend.types.dsl.IndexFieldTypeFactory;
import org.hibernate.search.engine.backend.types.dsl.IndexFieldTypeFactoryExtension;
import org.hibernate.search.engine.mapper.session.context.spi.SessionContextImplementor;
import org.hibernate.search.engine.search.dsl.predicate.SearchPredicateFactory;
import org.hibernate.search.engine.search.dsl.predicate.SearchPredicateFactoryExtension;
import org.hibernate.search.engine.search.dsl.projection.SearchProjectionFactory;
import org.hibernate.search.engine.search.dsl.projection.SearchProjectionFactoryExtension;
import org.hibernate.search.engine.search.dsl.query.SearchQueryDslExtension;
import org.hibernate.search.engine.search.dsl.query.SearchQueryHitTypeStep;
import org.hibernate.search.engine.search.dsl.sort.SearchSortFactory;
import org.hibernate.search.engine.search.dsl.sort.SearchSortFactoryExtension;
import org.hibernate.search.engine.search.dsl.sort.spi.SearchSortDslContext;
import org.hibernate.search.engine.search.loading.context.spi.LoadingContext;
import org.hibernate.search.engine.search.loading.context.spi.LoadingContextBuilder;
import org.hibernate.search.engine.search.predicate.spi.SearchPredicateBuilderFactory;
import org.hibernate.search.engine.search.projection.spi.SearchProjectionBuilderFactory;
import org.hibernate.search.engine.search.query.SearchQuery;
import org.hibernate.search.engine.search.query.SearchQueryExtension;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public final class ElasticsearchExtension<H, R, E>
implements SearchQueryDslExtension<ElasticsearchSearchQueryHitTypeStep<R, E>, R, E>,
SearchQueryExtension<ElasticsearchSearchQuery<H>, H>,
SearchPredicateFactoryExtension<ElasticsearchSearchPredicateFactory>,
SearchSortFactoryExtension<ElasticsearchSearchSortFactory>,
SearchProjectionFactoryExtension<ElasticsearchSearchProjectionFactory<R, E>, R, E>,
IndexFieldTypeFactoryExtension<ElasticsearchIndexFieldTypeFactory> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final ElasticsearchExtension<Object, Object, Object> INSTANCE = new ElasticsearchExtension();

    public static <H, R, E> ElasticsearchExtension<H, R, E> get() {
        return INSTANCE;
    }

    private ElasticsearchExtension() {
    }

    public Optional<ElasticsearchSearchQueryHitTypeStep<R, E>> extendOptional(SearchQueryHitTypeStep<?, R, E, ?, ?> original, IndexScope<?> indexScope, SessionContextImplementor sessionContext, LoadingContextBuilder<R, E> loadingContextBuilder) {
        if (indexScope instanceof ElasticsearchIndexScope) {
            return Optional.of(new ElasticsearchSearchQueryHitTypeStepImpl<R, E>((ElasticsearchIndexScope)indexScope, sessionContext, loadingContextBuilder));
        }
        return Optional.empty();
    }

    public Optional<ElasticsearchSearchQuery<H>> extendOptional(SearchQuery<H> original, LoadingContext<?, ?> loadingContext) {
        if (original instanceof ElasticsearchSearchQuery) {
            return Optional.of((ElasticsearchSearchQuery)original);
        }
        return Optional.empty();
    }

    public <C, B> Optional<ElasticsearchSearchPredicateFactory> extendOptional(SearchPredicateFactory original, SearchPredicateBuilderFactory<C, B> factory) {
        if (factory instanceof ElasticsearchSearchPredicateBuilderFactory) {
            return Optional.of(new ElasticsearchSearchPredicateFactoryImpl(original, (ElasticsearchSearchPredicateBuilderFactory)factory));
        }
        return Optional.empty();
    }

    public Optional<ElasticsearchSearchSortFactory> extendOptional(SearchSortFactory original, SearchSortDslContext<?, ?> dslContext) {
        if (dslContext.getBuilderFactory() instanceof ElasticsearchSearchSortBuilderFactory) {
            return Optional.of(new ElasticsearchSearchSortFactoryImpl(original, dslContext));
        }
        return Optional.empty();
    }

    public Optional<ElasticsearchSearchProjectionFactory<R, E>> extendOptional(SearchProjectionFactory<R, E> original, SearchProjectionBuilderFactory factory) {
        if (factory instanceof ElasticsearchSearchProjectionBuilderFactory) {
            return Optional.of(new ElasticsearchSearchProjectionFactoryImpl<R, E>(original, (ElasticsearchSearchProjectionBuilderFactory)factory));
        }
        return Optional.empty();
    }

    public ElasticsearchIndexFieldTypeFactory extendOrFail(IndexFieldTypeFactory original) {
        if (original instanceof ElasticsearchIndexFieldTypeFactory) {
            return (ElasticsearchIndexFieldTypeFactory)original;
        }
        throw log.elasticsearchExtensionOnUnknownType(original);
    }
}

