/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.analysis.model.dsl.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.lang.invoke.MethodHandles;
import java.util.LinkedHashMap;
import java.util.Map;
import org.hibernate.search.backend.elasticsearch.analysis.model.dsl.ElasticsearchAnalysisComponentParametersStep;
import org.hibernate.search.backend.elasticsearch.analysis.model.dsl.ElasticsearchAnalysisComponentTypeStep;
import org.hibernate.search.backend.elasticsearch.analysis.model.impl.ElasticsearchAnalysisDefinitionContributor;
import org.hibernate.search.backend.elasticsearch.analysis.model.impl.esnative.AnalysisDefinition;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

abstract class AbstractElasticsearchAnalysisComponentParametersStep<D extends AnalysisDefinition>
implements ElasticsearchAnalysisComponentParametersStep,
ElasticsearchAnalysisComponentTypeStep,
ElasticsearchAnalysisDefinitionContributor {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    protected final String name;
    protected final D definition;

    AbstractElasticsearchAnalysisComponentParametersStep(String name, D definition) {
        this.name = name;
        this.definition = definition;
    }

    @Override
    public ElasticsearchAnalysisComponentParametersStep type(String name) {
        ((AnalysisDefinition)this.definition).setType(name);
        return this;
    }

    private ElasticsearchAnalysisComponentParametersStep param(String name, JsonElement value) {
        JsonElement previous;
        Map<String, JsonElement> parameters = ((AnalysisDefinition)this.definition).getParameters();
        if (parameters == null) {
            parameters = new LinkedHashMap<String, JsonElement>();
            ((AnalysisDefinition)this.definition).setParameters(parameters);
        }
        if ((previous = parameters.putIfAbsent(name, value)) != null) {
            throw log.analysisComponentParameterConflict(name, previous, value);
        }
        return this;
    }

    @Override
    public ElasticsearchAnalysisComponentParametersStep param(String name, String value) {
        return this.param(name, (JsonElement)new JsonPrimitive(value));
    }

    @Override
    public ElasticsearchAnalysisComponentParametersStep param(String name, String ... values) {
        JsonArray array = new JsonArray();
        for (String value : values) {
            array.add(value);
        }
        return this.param(name, (JsonElement)array);
    }

    @Override
    public ElasticsearchAnalysisComponentParametersStep param(String name, boolean value) {
        return this.param(name, (JsonElement)new JsonPrimitive(Boolean.valueOf(value)));
    }

    @Override
    public ElasticsearchAnalysisComponentParametersStep param(String name, boolean ... values) {
        JsonArray array = new JsonArray();
        for (boolean value : values) {
            array.add(Boolean.valueOf(value));
        }
        return this.param(name, (JsonElement)array);
    }

    @Override
    public ElasticsearchAnalysisComponentParametersStep param(String name, Number value) {
        return this.param(name, (JsonElement)new JsonPrimitive(value));
    }

    @Override
    public ElasticsearchAnalysisComponentParametersStep param(String name, Number ... values) {
        JsonArray array = new JsonArray();
        for (Number value : values) {
            array.add(value);
        }
        return this.param(name, (JsonElement)array);
    }
}

