/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.analysis.model.dsl.impl;

import java.lang.invoke.MethodHandles;
import org.hibernate.search.backend.elasticsearch.analysis.model.dsl.ElasticsearchAnalyzerOptionalComponentsStep;
import org.hibernate.search.backend.elasticsearch.analysis.model.dsl.ElasticsearchAnalyzerTokenizerStep;
import org.hibernate.search.backend.elasticsearch.analysis.model.impl.ElasticsearchAnalysisDefinitionCollector;
import org.hibernate.search.backend.elasticsearch.analysis.model.impl.ElasticsearchAnalysisDefinitionContributor;
import org.hibernate.search.backend.elasticsearch.analysis.model.impl.esnative.AnalyzerDefinition;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.util.common.impl.StringHelper;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class ElasticsearchAnalyzerComponentsStep
implements ElasticsearchAnalyzerTokenizerStep,
ElasticsearchAnalyzerOptionalComponentsStep,
ElasticsearchAnalysisDefinitionContributor {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final String name;
    private final AnalyzerDefinition definition = new AnalyzerDefinition();

    ElasticsearchAnalyzerComponentsStep(String name) {
        this.name = name;
        this.definition.setType("custom");
    }

    @Override
    public ElasticsearchAnalyzerOptionalComponentsStep withTokenizer(String tokenizerName) {
        this.definition.setTokenizer(tokenizerName);
        return this;
    }

    @Override
    public ElasticsearchAnalyzerOptionalComponentsStep withCharFilters(String ... names) {
        this.definition.setCharFilters(null);
        for (String charFilterName : names) {
            this.definition.addCharFilter(charFilterName);
        }
        return this;
    }

    @Override
    public ElasticsearchAnalyzerOptionalComponentsStep withTokenFilters(String ... names) {
        this.definition.setTokenFilters(null);
        for (String tokenFilterName : names) {
            this.definition.addTokenFilter(tokenFilterName);
        }
        return this;
    }

    @Override
    public void contribute(ElasticsearchAnalysisDefinitionCollector collector) {
        if (StringHelper.isEmpty((String)this.definition.getTokenizer())) {
            throw log.invalidElasticsearchAnalyzerDefinition(this.name);
        }
        collector.collect(this.name, this.definition);
    }
}

