/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.document.model.dsl.impl;

import java.lang.invoke.MethodHandles;
import org.hibernate.search.backend.elasticsearch.document.impl.ElasticsearchIndexObjectFieldReference;
import org.hibernate.search.backend.elasticsearch.document.model.dsl.impl.AbstractElasticsearchIndexSchemaObjectNodeBuilder;
import org.hibernate.search.backend.elasticsearch.document.model.dsl.impl.ElasticsearchIndexSchemaRootNodeBuilder;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaNodeCollector;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaNodeContributor;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaObjectNode;
import org.hibernate.search.backend.elasticsearch.document.model.impl.esnative.AbstractTypeMapping;
import org.hibernate.search.backend.elasticsearch.document.model.impl.esnative.DynamicType;
import org.hibernate.search.backend.elasticsearch.document.model.impl.esnative.PropertyMapping;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonObjectAccessor;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.util.impl.ElasticsearchFields;
import org.hibernate.search.engine.backend.document.IndexObjectFieldReference;
import org.hibernate.search.engine.backend.document.model.dsl.ObjectFieldStorage;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexSchemaObjectFieldNodeBuilder;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

class ElasticsearchIndexSchemaObjectFieldNodeBuilder
extends AbstractElasticsearchIndexSchemaObjectNodeBuilder
implements IndexSchemaObjectFieldNodeBuilder,
ElasticsearchIndexSchemaNodeContributor {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final AbstractElasticsearchIndexSchemaObjectNodeBuilder parent;
    private final String absoluteFieldPath;
    private final String relativeFieldName;
    private final ObjectFieldStorage storage;
    private boolean multiValued = false;
    private ElasticsearchIndexObjectFieldReference reference;

    ElasticsearchIndexSchemaObjectFieldNodeBuilder(AbstractElasticsearchIndexSchemaObjectNodeBuilder parent, String relativeFieldName, ObjectFieldStorage storage) {
        this.parent = parent;
        String parentAbsolutePath = parent.getAbsolutePath();
        this.absoluteFieldPath = parentAbsolutePath == null ? relativeFieldName : ElasticsearchFields.compose(parentAbsolutePath, relativeFieldName);
        this.relativeFieldName = relativeFieldName;
        this.storage = storage;
    }

    public EventContext getEventContext() {
        return this.getRootNodeBuilder().getIndexEventContext().append(EventContexts.fromIndexFieldAbsolutePath((String)this.absoluteFieldPath));
    }

    public void multiValued() {
        this.multiValued = true;
    }

    public IndexObjectFieldReference toReference() {
        if (this.reference != null) {
            throw log.cannotCreateReferenceMultipleTimes(this.getEventContext());
        }
        JsonObjectAccessor jsonAccessor = JsonAccessor.root().property(this.relativeFieldName).asObject();
        this.reference = new ElasticsearchIndexObjectFieldReference(jsonAccessor);
        return this.reference;
    }

    @Override
    public void contribute(ElasticsearchIndexSchemaNodeCollector collector, ElasticsearchIndexSchemaObjectNode parentNode, AbstractTypeMapping parentMapping) {
        if (this.reference == null) {
            throw log.incompleteFieldDefinition(this.getEventContext());
        }
        ElasticsearchIndexSchemaObjectNode fieldNode = new ElasticsearchIndexSchemaObjectNode(parentNode, this.absoluteFieldPath, this.storage, this.multiValued);
        collector.collect(this.absoluteFieldPath, fieldNode);
        this.reference.enable(fieldNode);
        PropertyMapping mapping = new PropertyMapping();
        String dataType = "object";
        switch (this.storage) {
            case DEFAULT: {
                break;
            }
            case FLATTENED: {
                dataType = "object";
                break;
            }
            case NESTED: {
                dataType = "nested";
            }
        }
        mapping.setType(dataType);
        mapping.setDynamic(DynamicType.STRICT);
        parentMapping.addProperty(this.relativeFieldName, mapping);
        this.contributeChildren(mapping, fieldNode, collector);
    }

    @Override
    ElasticsearchIndexSchemaRootNodeBuilder getRootNodeBuilder() {
        return this.parent.getRootNodeBuilder();
    }

    @Override
    String getAbsolutePath() {
        return this.absoluteFieldPath;
    }
}

