/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.impl;

import com.google.gson.Gson;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.search.backend.elasticsearch.ElasticsearchBackend;
import org.hibernate.search.backend.elasticsearch.analysis.model.impl.ElasticsearchAnalysisDefinitionRegistry;
import org.hibernate.search.backend.elasticsearch.document.impl.ElasticsearchDocumentObjectBuilder;
import org.hibernate.search.backend.elasticsearch.document.model.dsl.impl.ElasticsearchIndexSchemaRootNodeBuilder;
import org.hibernate.search.backend.elasticsearch.impl.ElasticsearchIndexNameNormalizer;
import org.hibernate.search.backend.elasticsearch.impl.ElasticsearchLinkImpl;
import org.hibernate.search.backend.elasticsearch.index.impl.ElasticsearchIndexManagerBuilder;
import org.hibernate.search.backend.elasticsearch.index.impl.IndexingBackendContext;
import org.hibernate.search.backend.elasticsearch.index.settings.impl.ElasticsearchIndexSettingsBuilder;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.multitenancy.impl.MultiTenancyStrategy;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchWorkOrchestratorImplementor;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchWorkOrchestratorProvider;
import org.hibernate.search.backend.elasticsearch.search.query.impl.SearchBackendContext;
import org.hibernate.search.backend.elasticsearch.types.dsl.provider.impl.ElasticsearchIndexFieldTypeFactoryProvider;
import org.hibernate.search.engine.backend.Backend;
import org.hibernate.search.engine.backend.index.spi.IndexManagerBuilder;
import org.hibernate.search.engine.backend.spi.BackendBuildContext;
import org.hibernate.search.engine.backend.spi.BackendImplementor;
import org.hibernate.search.engine.backend.spi.BackendStartContext;
import org.hibernate.search.engine.cfg.spi.ConfigurationPropertySource;
import org.hibernate.search.engine.common.spi.ErrorHandler;
import org.hibernate.search.engine.common.spi.LogErrorHandler;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

class ElasticsearchBackendImpl
implements BackendImplementor<ElasticsearchDocumentObjectBuilder>,
ElasticsearchBackend {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final ElasticsearchLinkImpl link;
    private final String name;
    private final ElasticsearchWorkOrchestratorProvider orchestratorProvider;
    private final ElasticsearchIndexFieldTypeFactoryProvider typeFactoryProvider;
    private final ElasticsearchAnalysisDefinitionRegistry analysisDefinitionRegistry;
    private final MultiTenancyStrategy multiTenancyStrategy;
    private final ElasticsearchWorkOrchestratorImplementor queryOrchestrator;
    private final Map<String, String> hibernateSearchIndexNamesByElasticsearchIndexNames = new ConcurrentHashMap<String, String>();
    private final EventContext eventContext;
    private final IndexingBackendContext indexingContext;
    private final SearchBackendContext searchContext;

    ElasticsearchBackendImpl(ElasticsearchLinkImpl link, String name, ElasticsearchIndexFieldTypeFactoryProvider typeFactoryProvider, Gson userFacingGson, ElasticsearchAnalysisDefinitionRegistry analysisDefinitionRegistry, MultiTenancyStrategy multiTenancyStrategy) {
        this.link = link;
        this.name = name;
        this.orchestratorProvider = new ElasticsearchWorkOrchestratorProvider("Elasticsearch parallel work orchestrator for backend " + name, link, (ErrorHandler)new LogErrorHandler());
        this.analysisDefinitionRegistry = analysisDefinitionRegistry;
        this.multiTenancyStrategy = multiTenancyStrategy;
        this.queryOrchestrator = this.orchestratorProvider.createParallelOrchestrator("Elasticsearch query orchestrator for backend " + name);
        this.typeFactoryProvider = typeFactoryProvider;
        this.eventContext = EventContexts.fromBackendName((String)name);
        this.indexingContext = new IndexingBackendContext(this.eventContext, link, multiTenancyStrategy, this.orchestratorProvider);
        this.searchContext = new SearchBackendContext(this.eventContext, link, userFacingGson, elasticsearchIndexName -> {
            String result = this.hibernateSearchIndexNamesByElasticsearchIndexNames.get(elasticsearchIndexName);
            if (result == null) {
                throw log.elasticsearchResponseUnknownIndexName((String)elasticsearchIndexName, this.eventContext);
            }
            return result;
        }, multiTenancyStrategy, this.queryOrchestrator);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "name=" + this.name + "]";
    }

    public void close() {
        try (Closer closer = new Closer();){
            closer.push(ElasticsearchWorkOrchestratorImplementor::close, (Object)this.queryOrchestrator);
            closer.push(ElasticsearchWorkOrchestratorProvider::close, (Object)this.orchestratorProvider);
            closer.push(ElasticsearchLinkImpl::onStop, (Object)this.link);
        }
        catch (IOException | RuntimeException e) {
            throw log.failedToShutdownBackend(e, this.eventContext);
        }
    }

    public void start(BackendStartContext context) {
        this.link.onStart(context.getConfigurationPropertySource());
        this.orchestratorProvider.start();
        this.queryOrchestrator.start();
    }

    public <T> T unwrap(Class<T> clazz) {
        if (clazz.isAssignableFrom(ElasticsearchBackend.class)) {
            return (T)this;
        }
        throw log.backendUnwrappingWithUnknownType(clazz, ElasticsearchBackend.class, this.eventContext);
    }

    public Backend toAPI() {
        return this;
    }

    @Override
    public <T> T getClient(Class<T> clientClass) {
        return this.link.getClient().unwrap(clientClass);
    }

    public IndexManagerBuilder<ElasticsearchDocumentObjectBuilder> createIndexManagerBuilder(String hibernateSearchIndexName, boolean multiTenancyEnabled, BackendBuildContext buildContext, ConfigurationPropertySource propertySource) {
        if (multiTenancyEnabled && !this.multiTenancyStrategy.isMultiTenancySupported()) {
            throw log.multiTenancyRequiredButNotSupportedByBackend(hibernateSearchIndexName, this.eventContext);
        }
        String elasticsearchIndexName = ElasticsearchIndexNameNormalizer.normalize(hibernateSearchIndexName);
        String existingHibernateSearchIndexName = this.hibernateSearchIndexNamesByElasticsearchIndexNames.putIfAbsent(elasticsearchIndexName, hibernateSearchIndexName);
        if (existingHibernateSearchIndexName != null) {
            throw log.duplicateNormalizedIndexNames(existingHibernateSearchIndexName, hibernateSearchIndexName, elasticsearchIndexName, this.eventContext);
        }
        EventContext indexEventContext = EventContexts.fromIndexName((String)hibernateSearchIndexName);
        ElasticsearchIndexSchemaRootNodeBuilder indexSchemaRootNodeBuilder = new ElasticsearchIndexSchemaRootNodeBuilder(this.typeFactoryProvider, indexEventContext, this.multiTenancyStrategy);
        ElasticsearchIndexSettingsBuilder settingsBuilder = new ElasticsearchIndexSettingsBuilder(this.analysisDefinitionRegistry);
        return new ElasticsearchIndexManagerBuilder(this.indexingContext, this.searchContext, hibernateSearchIndexName, elasticsearchIndexName, indexSchemaRootNodeBuilder, settingsBuilder);
    }
}

