/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.index.admin.impl;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletionException;
import org.hibernate.search.backend.elasticsearch.cfg.ElasticsearchIndexStatus;
import org.hibernate.search.backend.elasticsearch.document.model.impl.esnative.RootTypeMapping;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.ElasticsearchIndexLifecycleExecutionOptions;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.IndexMetadata;
import org.hibernate.search.backend.elasticsearch.index.settings.impl.esnative.IndexSettings;
import org.hibernate.search.backend.elasticsearch.link.impl.ElasticsearchLink;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchWorkOrchestrator;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.backend.elasticsearch.work.builder.factory.impl.ElasticsearchWorkBuilderFactory;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchWork;
import org.hibernate.search.backend.elasticsearch.work.result.impl.CreateIndexResult;
import org.hibernate.search.util.common.impl.Futures;
import org.hibernate.search.util.common.impl.Throwables;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class ElasticsearchSchemaAccessor {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final ElasticsearchLink link;
    private final ElasticsearchWorkOrchestrator orchestrator;

    public ElasticsearchSchemaAccessor(ElasticsearchLink link, ElasticsearchWorkOrchestrator orchestrator) {
        this.link = link;
        this.orchestrator = orchestrator;
    }

    public void createIndex(URLEncodedString indexName, IndexSettings settings, RootTypeMapping mapping) {
        Object work = this.getWorkFactory().createIndex(indexName).settings(settings).mapping(mapping).build();
        this.execute((ElasticsearchWork)work);
    }

    public boolean createIndexIfAbsent(URLEncodedString indexName, IndexSettings settings, RootTypeMapping mapping) {
        Object work = this.getWorkFactory().createIndex(indexName).settings(settings).mapping(mapping).ignoreExisting().build();
        CreateIndexResult result = (CreateIndexResult)((Object)this.execute((ElasticsearchWork)work));
        return CreateIndexResult.CREATED.equals((Object)result);
    }

    public boolean indexExists(URLEncodedString indexName) {
        Object work = this.getWorkFactory().indexExists(indexName).build();
        return (Boolean)this.execute((ElasticsearchWork)work);
    }

    public IndexMetadata getCurrentIndexMetadata(URLEncodedString indexName) {
        IndexMetadata indexMetadata = new IndexMetadata();
        indexMetadata.setName(indexName);
        Object getMappingWork = this.getWorkFactory().getIndexTypeMapping(indexName).build();
        try {
            RootTypeMapping mapping = (RootTypeMapping)this.execute((ElasticsearchWork)getMappingWork);
            indexMetadata.setMapping(mapping);
        }
        catch (RuntimeException e) {
            throw log.elasticsearchMappingRetrievalForValidationFailed(e);
        }
        Object getSettingsWork = this.getWorkFactory().getIndexSettings(indexName).build();
        try {
            IndexSettings indexSettings = (IndexSettings)this.execute((ElasticsearchWork)getSettingsWork);
            indexMetadata.setSettings(indexSettings);
        }
        catch (RuntimeException e) {
            throw log.elasticsearchIndexSettingsRetrievalForValidationFailed(e);
        }
        return indexMetadata;
    }

    public void updateSettings(URLEncodedString indexName, IndexSettings settings) {
        Object work = this.getWorkFactory().putIndexSettings(indexName, settings).build();
        try {
            this.execute((ElasticsearchWork)work);
        }
        catch (RuntimeException e) {
            throw log.elasticsearchSettingsUpdateFailed(indexName, e);
        }
    }

    public void putMapping(URLEncodedString indexName, RootTypeMapping mapping) {
        Object work = this.getWorkFactory().putIndexTypeMapping(indexName, mapping).build();
        try {
            this.execute((ElasticsearchWork)work);
        }
        catch (RuntimeException e) {
            throw log.elasticsearchMappingCreationFailed(indexName.original, e.getMessage(), e);
        }
    }

    public void waitForIndexStatus(URLEncodedString indexName, ElasticsearchIndexLifecycleExecutionOptions executionOptions) {
        ElasticsearchIndexStatus requiredIndexStatus = executionOptions.getRequiredStatus();
        String timeoutAndUnit = executionOptions.getRequiredStatusTimeoutInMs() + "ms";
        Object work = this.getWorkFactory().waitForIndexStatusWork(indexName, requiredIndexStatus, timeoutAndUnit).build();
        try {
            this.execute((ElasticsearchWork)work);
        }
        catch (RuntimeException e) {
            throw log.unexpectedIndexStatus(indexName.original, requiredIndexStatus.getElasticsearchString(), timeoutAndUnit, e);
        }
    }

    public void dropIndexIfExisting(URLEncodedString indexName) {
        Object work = this.getWorkFactory().dropIndex(indexName).ignoreIndexNotFound().build();
        this.execute((ElasticsearchWork)work);
    }

    public void closeIndex(URLEncodedString indexName) {
        Object work = this.getWorkFactory().closeIndex(indexName).build();
        this.execute((ElasticsearchWork)work);
        log.closedIndex(indexName);
    }

    public void openIndex(URLEncodedString indexName) {
        try {
            Object work = this.getWorkFactory().openIndex(indexName).build();
            this.execute((ElasticsearchWork)work);
        }
        catch (RuntimeException e) {
            log.openedIndex(indexName);
            throw e;
        }
        log.openedIndex(indexName);
    }

    private ElasticsearchWorkBuilderFactory getWorkFactory() {
        return this.link.getWorkBuilderFactory();
    }

    private <T> T execute(ElasticsearchWork<T> work) {
        try {
            return (T)Futures.unwrappedExceptionJoin(this.orchestrator.submit(work));
        }
        catch (CompletionException e) {
            throw Throwables.expectRuntimeException((Throwable)e);
        }
    }
}

